// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TransformManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.TransformManagement.Json.TimeSyncConverter))]
public sealed partial class TimeSync
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TimeSync(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public TimeSync()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TimeSync()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TimeSync(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The time delay between the current time and the latest input data time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Delay { get; set; }

	/// <summary>
	/// <para>
	/// The date field that is used to identify new documents in the source. In general, it’s a good idea to use a field
	/// that contains the ingest timestamp. If you use a different field, you might need to set the delay such that it
	/// accounts for data transmission delays.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }
}

public readonly partial struct TimeSyncDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.TimeSync Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TimeSyncDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.TimeSync instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TimeSyncDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.TimeSync(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor<TDocument>(Elastic.Clients.Elasticsearch.TransformManagement.TimeSync instance) => new Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.TimeSync(Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The time delay between the current time and the latest input data time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor<TDocument> Delay(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Delay = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field that is used to identify new documents in the source. In general, it’s a good idea to use a field
	/// that contains the ingest timestamp. If you use a different field, you might need to set the delay such that it
	/// accounts for data transmission delays.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field that is used to identify new documents in the source. In general, it’s a good idea to use a field
	/// that contains the ingest timestamp. If you use a different field, you might need to set the delay such that it
	/// accounts for data transmission delays.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.TimeSync Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.TransformManagement.TimeSync(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct TimeSyncDescriptor
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.TimeSync Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TimeSyncDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.TimeSync instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TimeSyncDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.TimeSync(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.TimeSync instance) => new Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.TimeSync(Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The time delay between the current time and the latest input data time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor Delay(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Delay = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field that is used to identify new documents in the source. In general, it’s a good idea to use a field
	/// that contains the ingest timestamp. If you use a different field, you might need to set the delay such that it
	/// accounts for data transmission delays.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field that is used to identify new documents in the source. In general, it’s a good idea to use a field
	/// that contains the ingest timestamp. If you use a different field, you might need to set the delay such that it
	/// accounts for data transmission delays.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.TimeSync Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.TimeSyncDescriptor(new Elastic.Clients.Elasticsearch.TransformManagement.TimeSync(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}