// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TransformManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.TransformManagement.Json.TimeRetentionPolicyConverter))]
public sealed partial class TimeRetentionPolicy
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TimeRetentionPolicy(Elastic.Clients.Elasticsearch.Field field, Elastic.Clients.Elasticsearch.Duration maxAge)
	{
		Field = field;
		MaxAge = maxAge;
	}
#if NET7_0_OR_GREATER
	public TimeRetentionPolicy()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TimeRetentionPolicy()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TimeRetentionPolicy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The date field that is used to calculate the age of the document.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the maximum age of a document in the destination index. Documents that are older than the configured
	/// value are removed from the destination index.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Duration MaxAge { get; set; }
}

public readonly partial struct TimeRetentionPolicyDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TimeRetentionPolicyDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TimeRetentionPolicyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor<TDocument>(Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy instance) => new Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy(Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The date field that is used to calculate the age of the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field that is used to calculate the age of the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the maximum age of a document in the destination index. Documents that are older than the configured
	/// value are removed from the destination index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor<TDocument> MaxAge(Elastic.Clients.Elasticsearch.Duration value)
	{
		Instance.MaxAge = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct TimeRetentionPolicyDescriptor
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TimeRetentionPolicyDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TimeRetentionPolicyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy instance) => new Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy(Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The date field that is used to calculate the age of the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field that is used to calculate the age of the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the maximum age of a document in the destination index. Documents that are older than the configured
	/// value are removed from the destination index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor MaxAge(Elastic.Clients.Elasticsearch.Duration value)
	{
		Instance.MaxAge = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor(new Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}