// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TransformManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.TransformManagement.Json.SourceConverter))]
public sealed partial class Source
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public Source(Elastic.Clients.Elasticsearch.Indices indices)
	{
		Indices = indices;
	}
#if NET7_0_OR_GREATER
	public Source()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public Source()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Source(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The source indices for the transform. It can be a single index, an index pattern (for example, <c>"my-index-*""</c>), an
	/// array of indices (for example, <c>["my-index-000001", "my-index-000002"]</c>), or an array of index patterns (for
	/// example, <c>["my-index-*", "my-other-index-*"]</c>. For remote indices use the syntax <c>"remote_name:index_name"</c>. If
	/// any indices are in remote clusters then the master node and at least one transform node must have the <c>remote_cluster_client</c> node role.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Indices Indices { get; set; }

	/// <summary>
	/// <para>
	/// A query clause that retrieves a subset of data from the source index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Query { get; set; }

	/// <summary>
	/// <para>
	/// Definitions of search-time runtime fields that can be used by the transform. For search runtime fields all data
	/// nodes, including remote nodes, must be 7.12 or later.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? RuntimeMappings { get; set; }
}

public readonly partial struct SourceDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.Source Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SourceDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.Source instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SourceDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.Source(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor<TDocument>(Elastic.Clients.Elasticsearch.TransformManagement.Source instance) => new Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.Source(Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The source indices for the transform. It can be a single index, an index pattern (for example, <c>"my-index-*""</c>), an
	/// array of indices (for example, <c>["my-index-000001", "my-index-000002"]</c>), or an array of index patterns (for
	/// example, <c>["my-index-*", "my-other-index-*"]</c>. For remote indices use the syntax <c>"remote_name:index_name"</c>. If
	/// any indices are in remote clusters then the master node and at least one transform node must have the <c>remote_cluster_client</c> node role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor<TDocument> Indices(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query clause that retrieves a subset of data from the source index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor<TDocument> Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query clause that retrieves a subset of data from the source index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor<TDocument> Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Definitions of search-time runtime fields that can be used by the transform. For search runtime fields all data
	/// nodes, including remote nodes, must be 7.12 or later.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor<TDocument> RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Definitions of search-time runtime fields that can be used by the transform. For search runtime fields all data
	/// nodes, including remote nodes, must be 7.12 or later.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor<TDocument> RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Definitions of search-time runtime fields that can be used by the transform. For search runtime fields all data
	/// nodes, including remote nodes, must be 7.12 or later.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor<TDocument> RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.Source Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.TransformManagement.Source(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct SourceDescriptor
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.Source Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SourceDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.Source instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SourceDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.Source(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.Source instance) => new Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.Source(Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The source indices for the transform. It can be a single index, an index pattern (for example, <c>"my-index-*""</c>), an
	/// array of indices (for example, <c>["my-index-000001", "my-index-000002"]</c>), or an array of index patterns (for
	/// example, <c>["my-index-*", "my-other-index-*"]</c>. For remote indices use the syntax <c>"remote_name:index_name"</c>. If
	/// any indices are in remote clusters then the master node and at least one transform node must have the <c>remote_cluster_client</c> node role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor Indices(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query clause that retrieves a subset of data from the source index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query clause that retrieves a subset of data from the source index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A query clause that retrieves a subset of data from the source index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor Query<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Definitions of search-time runtime fields that can be used by the transform. For search runtime fields all data
	/// nodes, including remote nodes, must be 7.12 or later.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Definitions of search-time runtime fields that can be used by the transform. For search runtime fields all data
	/// nodes, including remote nodes, must be 7.12 or later.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Definitions of search-time runtime fields that can be used by the transform. For search runtime fields all data
	/// nodes, including remote nodes, must be 7.12 or later.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Definitions of search-time runtime fields that can be used by the transform. For search runtime fields all data
	/// nodes, including remote nodes, must be 7.12 or later.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor RuntimeMappings<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor AddRuntimeMapping<T>(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.Source Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.SourceDescriptor(new Elastic.Clients.Elasticsearch.TransformManagement.Source(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}