// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TransformManagement;

/// <summary>
/// <para>
/// The source of the data for the transform.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.TransformManagement.Json.SettingsConverter))]
public sealed partial class Settings
{
#if NET7_0_OR_GREATER
	public Settings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Settings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Settings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Specifies whether the transform checkpoint ranges should be optimized for performance. Such optimization can align
	/// checkpoint ranges with the date histogram interval when date histogram is specified as a group source in the
	/// transform config. As a result, less document updates in the destination index will be performed thus improving
	/// overall performance.
	/// </para>
	/// </summary>
	public bool? AlignCheckpoints { get; set; }

	/// <summary>
	/// <para>
	/// Defines if dates in the ouput should be written as ISO formatted string or as millis since epoch. epoch_millis was
	/// the default for transforms created before version 7.11. For compatible output set this value to <c>true</c>.
	/// </para>
	/// </summary>
	public bool? DatesAsEpochMillis { get; set; }

	/// <summary>
	/// <para>
	/// Specifies whether the transform should deduce the destination index mappings from the transform configuration.
	/// </para>
	/// </summary>
	public bool? DeduceMappings { get; set; }

	/// <summary>
	/// <para>
	/// Specifies a limit on the number of input documents per second. This setting throttles the transform by adding a
	/// wait time between search requests. The default value is null, which disables throttling.
	/// </para>
	/// </summary>
	public float? DocsPerSecond { get; set; }

	/// <summary>
	/// <para>
	/// Defines the initial page size to use for the composite aggregation for each checkpoint. If circuit breaker
	/// exceptions occur, the page size is dynamically adjusted to a lower value. The minimum value is <c>10</c> and the
	/// maximum is <c>65,536</c>.
	/// </para>
	/// </summary>
	public int? MaxPageSearchSize { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the transform runs in unattended mode. In unattended mode, the transform retries indefinitely in case
	/// of an error which means the transform never fails. Setting the number of retries other than infinite fails in
	/// validation.
	/// </para>
	/// </summary>
	public bool? Unattended { get; set; }

	/// <summary>
	/// <para>
	/// Specifies whether the transform checkpoint will use the Point In Time API while searching over the source index.
	/// In general, Point In Time is an optimization that will reduce pressure on the source index by reducing the amount
	/// of refreshes and merges, but it can be expensive if a large number of Point In Times are opened and closed for a
	/// given index. The benefits and impact depend on the data being searched, the ingest rate into the source index, and
	/// the amount of other consumers searching the same source index.
	/// </para>
	/// </summary>
	public bool? UsePointInTime { get; set; }
}

/// <summary>
/// <para>
/// The source of the data for the transform.
/// </para>
/// </summary>
public readonly partial struct SettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.Settings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SettingsDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.Settings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.Settings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.SettingsDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.Settings instance) => new Elastic.Clients.Elasticsearch.TransformManagement.SettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.Settings(Elastic.Clients.Elasticsearch.TransformManagement.SettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies whether the transform checkpoint ranges should be optimized for performance. Such optimization can align
	/// checkpoint ranges with the date histogram interval when date histogram is specified as a group source in the
	/// transform config. As a result, less document updates in the destination index will be performed thus improving
	/// overall performance.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SettingsDescriptor AlignCheckpoints(bool? value = true)
	{
		Instance.AlignCheckpoints = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines if dates in the ouput should be written as ISO formatted string or as millis since epoch. epoch_millis was
	/// the default for transforms created before version 7.11. For compatible output set this value to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SettingsDescriptor DatesAsEpochMillis(bool? value = true)
	{
		Instance.DatesAsEpochMillis = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether the transform should deduce the destination index mappings from the transform configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SettingsDescriptor DeduceMappings(bool? value = true)
	{
		Instance.DeduceMappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies a limit on the number of input documents per second. This setting throttles the transform by adding a
	/// wait time between search requests. The default value is null, which disables throttling.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SettingsDescriptor DocsPerSecond(float? value)
	{
		Instance.DocsPerSecond = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the initial page size to use for the composite aggregation for each checkpoint. If circuit breaker
	/// exceptions occur, the page size is dynamically adjusted to a lower value. The minimum value is <c>10</c> and the
	/// maximum is <c>65,536</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SettingsDescriptor MaxPageSearchSize(int? value)
	{
		Instance.MaxPageSearchSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the transform runs in unattended mode. In unattended mode, the transform retries indefinitely in case
	/// of an error which means the transform never fails. Setting the number of retries other than infinite fails in
	/// validation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SettingsDescriptor Unattended(bool? value = true)
	{
		Instance.Unattended = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether the transform checkpoint will use the Point In Time API while searching over the source index.
	/// In general, Point In Time is an optimization that will reduce pressure on the source index by reducing the amount
	/// of refreshes and merges, but it can be expensive if a large number of Point In Times are opened and closed for a
	/// given index. The benefits and impact depend on the data being searched, the ingest rate into the source index, and
	/// the amount of other consumers searching the same source index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SettingsDescriptor UsePointInTime(bool? value = true)
	{
		Instance.UsePointInTime = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.Settings Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.SettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.TransformManagement.Settings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.SettingsDescriptor(new Elastic.Clients.Elasticsearch.TransformManagement.Settings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}