// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TransformManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.TransformManagement.Json.RetentionPolicyConverter))]
public sealed partial class RetentionPolicy
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public RetentionPolicy()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RetentionPolicy()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RetentionPolicy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Specifies that the transform uses a time field to set the retention policy.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy? Time { get => GetVariant<Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy>("time"); set => SetVariant("time", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy(Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy value) => new Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy { Time = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct RetentionPolicyDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RetentionPolicyDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RetentionPolicyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicyDescriptor<TDocument>(Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy instance) => new Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicyDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy(Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicyDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies that the transform uses a time field to set the retention policy.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicyDescriptor<TDocument> Time(Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy? value)
	{
		Instance.Time = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies that the transform uses a time field to set the retention policy.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicyDescriptor<TDocument> Time(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor<TDocument>> action)
	{
		Instance.Time = Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicyDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicyDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct RetentionPolicyDescriptor
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RetentionPolicyDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RetentionPolicyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicyDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy instance) => new Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicyDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy(Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicyDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies that the transform uses a time field to set the retention policy.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicyDescriptor Time(Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicy? value)
	{
		Instance.Time = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies that the transform uses a time field to set the retention policy.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicyDescriptor Time(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor> action)
	{
		Instance.Time = Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies that the transform uses a time field to set the retention policy.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicyDescriptor Time<T>(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor<T>> action)
	{
		Instance.Time = Elastic.Clients.Elasticsearch.TransformManagement.TimeRetentionPolicyDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicyDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicyDescriptor(new Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}