// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TransformManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.TransformManagement.Json.PivotGroupByConverter))]
public sealed partial class PivotGroupBy
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public PivotGroupBy()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public PivotGroupBy()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PivotGroupBy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation? DateHistogram { get => GetVariant<Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation>("date_histogram"); set => SetVariant("date_histogram", value); }
	public Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregation? GeotileGrid { get => GetVariant<Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregation>("geotile_grid"); set => SetVariant("geotile_grid", value); }
	public Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregation? Histogram { get => GetVariant<Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregation>("histogram"); set => SetVariant("histogram", value); }
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation? Terms { get => GetVariant<Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation>("terms"); set => SetVariant("terms", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy(Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation value) => new Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy { DateHistogram = value };
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy(Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregation value) => new Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy { GeotileGrid = value };
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy(Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregation value) => new Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy { Histogram = value };
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation value) => new Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy { Terms = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct PivotGroupByDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PivotGroupByDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PivotGroupByDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument>(Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy instance) => new Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy(Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument> DateHistogram(Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation? value)
	{
		Instance.DateHistogram = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument> DateHistogram()
	{
		Instance.DateHistogram = Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument> DateHistogram(System.Action<Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument>>? action)
	{
		Instance.DateHistogram = Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument> GeotileGrid(Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregation? value)
	{
		Instance.GeotileGrid = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument> GeotileGrid()
	{
		Instance.GeotileGrid = Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregationDescriptor<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument> GeotileGrid(System.Action<Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregationDescriptor<TDocument>>? action)
	{
		Instance.GeotileGrid = Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregationDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument> Histogram(Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregation? value)
	{
		Instance.Histogram = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument> Histogram()
	{
		Instance.Histogram = Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregationDescriptor<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument> Histogram(System.Action<Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregationDescriptor<TDocument>>? action)
	{
		Instance.Histogram = Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregationDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument> Terms(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation? value)
	{
		Instance.Terms = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument> Terms()
	{
		Instance.Terms = Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument> Terms(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument>>? action)
	{
		Instance.Terms = Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct PivotGroupByDescriptor
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PivotGroupByDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PivotGroupByDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy instance) => new Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy(Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor DateHistogram(Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation? value)
	{
		Instance.DateHistogram = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor DateHistogram()
	{
		Instance.DateHistogram = Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor DateHistogram(System.Action<Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor>? action)
	{
		Instance.DateHistogram = Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor DateHistogram<T>(System.Action<Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<T>>? action)
	{
		Instance.DateHistogram = Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor GeotileGrid(Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregation? value)
	{
		Instance.GeotileGrid = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor GeotileGrid()
	{
		Instance.GeotileGrid = Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregationDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor GeotileGrid(System.Action<Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregationDescriptor>? action)
	{
		Instance.GeotileGrid = Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregationDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor GeotileGrid<T>(System.Action<Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregationDescriptor<T>>? action)
	{
		Instance.GeotileGrid = Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregationDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor Histogram(Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregation? value)
	{
		Instance.Histogram = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor Histogram()
	{
		Instance.Histogram = Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregationDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor Histogram(System.Action<Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregationDescriptor>? action)
	{
		Instance.Histogram = Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregationDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor Histogram<T>(System.Action<Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregationDescriptor<T>>? action)
	{
		Instance.Histogram = Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregationDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor Terms(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation? value)
	{
		Instance.Terms = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor Terms()
	{
		Instance.Terms = Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor Terms(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor>? action)
	{
		Instance.Terms = Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor Terms<T>(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<T>>? action)
	{
		Instance.Terms = Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor(new Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}