// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TransformManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.TransformManagement.Json.PivotConverter))]
public sealed partial class Pivot
{
#if NET7_0_OR_GREATER
	public Pivot()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Pivot()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Pivot(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Defines how to aggregate the grouped data. The following aggregations are currently supported: average, bucket
	/// script, bucket selector, cardinality, filter, geo bounds, geo centroid, geo line, max, median absolute deviation,
	/// min, missing, percentiles, rare terms, scripted metric, stats, sum, terms, top metrics, value count, weighted
	/// average.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? Aggregations { get; set; }

	/// <summary>
	/// <para>
	/// Defines how to group the data. More than one grouping can be defined per pivot. The following groupings are
	/// currently supported: date histogram, geotile grid, histogram, terms.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy>? GroupBy { get; set; }
}

public readonly partial struct PivotDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.Pivot Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PivotDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.Pivot instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PivotDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.Pivot(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor<TDocument>(Elastic.Clients.Elasticsearch.TransformManagement.Pivot instance) => new Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.Pivot(Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Defines how to aggregate the grouped data. The following aggregations are currently supported: average, bucket
	/// script, bucket selector, cardinality, filter, geo bounds, geo centroid, geo line, max, median absolute deviation,
	/// min, missing, percentiles, rare terms, scripted metric, stats, sum, terms, top metrics, value count, weighted
	/// average.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor<TDocument> Aggregations(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? value)
	{
		Instance.Aggregations = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines how to aggregate the grouped data. The following aggregations are currently supported: average, bucket
	/// script, bucket selector, cardinality, filter, geo bounds, geo centroid, geo line, max, median absolute deviation,
	/// min, missing, percentiles, rare terms, scripted metric, stats, sum, terms, top metrics, value count, weighted
	/// average.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor<TDocument> Aggregations()
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines how to aggregate the grouped data. The following aggregations are currently supported: average, bucket
	/// script, bucket selector, cardinality, filter, geo bounds, geo centroid, geo line, max, median absolute deviation,
	/// min, missing, percentiles, rare terms, scripted metric, stats, sum, terms, top metrics, value count, weighted
	/// average.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor<TDocument> Aggregations(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<TDocument>>? action)
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor<TDocument> AddAggregation(string key, Elastic.Clients.Elasticsearch.Aggregations.Aggregation value)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor<TDocument> AddAggregation(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<TDocument>> action)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines how to group the data. More than one grouping can be defined per pivot. The following groupings are
	/// currently supported: date histogram, geotile grid, histogram, terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor<TDocument> GroupBy(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy>? value)
	{
		Instance.GroupBy = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines how to group the data. More than one grouping can be defined per pivot. The following groupings are
	/// currently supported: date histogram, geotile grid, histogram, terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor<TDocument> GroupBy()
	{
		Instance.GroupBy = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPivotGroupBy<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines how to group the data. More than one grouping can be defined per pivot. The following groupings are
	/// currently supported: date histogram, geotile grid, histogram, terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor<TDocument> GroupBy(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPivotGroupBy<TDocument>>? action)
	{
		Instance.GroupBy = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPivotGroupBy<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor<TDocument> AddGroupBy(string key, Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy value)
	{
		Instance.GroupBy ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy>();
		Instance.GroupBy.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor<TDocument> AddGroupBy(string key, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument>> action)
	{
		Instance.GroupBy ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy>();
		Instance.GroupBy.Add(key, Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<TDocument>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.Pivot Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.TransformManagement.Pivot(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.TransformManagement.Pivot(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct PivotDescriptor
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.Pivot Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PivotDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.Pivot instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PivotDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.Pivot(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.Pivot instance) => new Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.Pivot(Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Defines how to aggregate the grouped data. The following aggregations are currently supported: average, bucket
	/// script, bucket selector, cardinality, filter, geo bounds, geo centroid, geo line, max, median absolute deviation,
	/// min, missing, percentiles, rare terms, scripted metric, stats, sum, terms, top metrics, value count, weighted
	/// average.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor Aggregations(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? value)
	{
		Instance.Aggregations = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines how to aggregate the grouped data. The following aggregations are currently supported: average, bucket
	/// script, bucket selector, cardinality, filter, geo bounds, geo centroid, geo line, max, median absolute deviation,
	/// min, missing, percentiles, rare terms, scripted metric, stats, sum, terms, top metrics, value count, weighted
	/// average.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor Aggregations()
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines how to aggregate the grouped data. The following aggregations are currently supported: average, bucket
	/// script, bucket selector, cardinality, filter, geo bounds, geo centroid, geo line, max, median absolute deviation,
	/// min, missing, percentiles, rare terms, scripted metric, stats, sum, terms, top metrics, value count, weighted
	/// average.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor Aggregations(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation>? action)
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines how to aggregate the grouped data. The following aggregations are currently supported: average, bucket
	/// script, bucket selector, cardinality, filter, geo bounds, geo centroid, geo line, max, median absolute deviation,
	/// min, missing, percentiles, rare terms, scripted metric, stats, sum, terms, top metrics, value count, weighted
	/// average.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor Aggregations<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<T>>? action)
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor AddAggregation(string key, Elastic.Clients.Elasticsearch.Aggregations.Aggregation value)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor AddAggregation(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor> action)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor AddAggregation<T>(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<T>> action)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines how to group the data. More than one grouping can be defined per pivot. The following groupings are
	/// currently supported: date histogram, geotile grid, histogram, terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor GroupBy(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy>? value)
	{
		Instance.GroupBy = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines how to group the data. More than one grouping can be defined per pivot. The following groupings are
	/// currently supported: date histogram, geotile grid, histogram, terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor GroupBy()
	{
		Instance.GroupBy = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPivotGroupBy.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines how to group the data. More than one grouping can be defined per pivot. The following groupings are
	/// currently supported: date histogram, geotile grid, histogram, terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor GroupBy(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPivotGroupBy>? action)
	{
		Instance.GroupBy = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPivotGroupBy.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines how to group the data. More than one grouping can be defined per pivot. The following groupings are
	/// currently supported: date histogram, geotile grid, histogram, terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor GroupBy<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPivotGroupBy<T>>? action)
	{
		Instance.GroupBy = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPivotGroupBy<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor AddGroupBy(string key, Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy value)
	{
		Instance.GroupBy ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy>();
		Instance.GroupBy.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor AddGroupBy(string key, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor> action)
	{
		Instance.GroupBy ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy>();
		Instance.GroupBy.Add(key, Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor AddGroupBy<T>(string key, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<T>> action)
	{
		Instance.GroupBy ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupBy>();
		Instance.GroupBy.Add(key, Elastic.Clients.Elasticsearch.TransformManagement.PivotGroupByDescriptor<T>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.Pivot Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.TransformManagement.Pivot(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PivotDescriptor(new Elastic.Clients.Elasticsearch.TransformManagement.Pivot(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}