// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.TopRightBottomLeftGeoBoundsConverter))]
public sealed partial class TopRightBottomLeftGeoBounds
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TopRightBottomLeftGeoBounds(Elastic.Clients.Elasticsearch.GeoLocation bottomLeft, Elastic.Clients.Elasticsearch.GeoLocation topRight)
	{
		BottomLeft = bottomLeft;
		TopRight = topRight;
	}
#if NET7_0_OR_GREATER
	public TopRightBottomLeftGeoBounds()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TopRightBottomLeftGeoBounds()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TopRightBottomLeftGeoBounds(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.GeoLocation BottomLeft { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.GeoLocation TopRight { get; set; }
}

public readonly partial struct TopRightBottomLeftGeoBoundsDescriptor
{
	internal Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBounds Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TopRightBottomLeftGeoBoundsDescriptor(Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBounds instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TopRightBottomLeftGeoBoundsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBounds(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBoundsDescriptor(Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBounds instance) => new Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBoundsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBounds(Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBoundsDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBoundsDescriptor BottomLeft(Elastic.Clients.Elasticsearch.GeoLocation value)
	{
		Instance.BottomLeft = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBoundsDescriptor BottomLeft(System.Func<Elastic.Clients.Elasticsearch.GeoLocationFactory, Elastic.Clients.Elasticsearch.GeoLocation> action)
	{
		Instance.BottomLeft = Elastic.Clients.Elasticsearch.GeoLocationFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBoundsDescriptor TopRight(Elastic.Clients.Elasticsearch.GeoLocation value)
	{
		Instance.TopRight = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBoundsDescriptor TopRight(System.Func<Elastic.Clients.Elasticsearch.GeoLocationFactory, Elastic.Clients.Elasticsearch.GeoLocation> action)
	{
		Instance.TopRight = Elastic.Clients.Elasticsearch.GeoLocationFactory.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBounds Build(System.Action<Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBoundsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBoundsDescriptor(new Elastic.Clients.Elasticsearch.TopRightBottomLeftGeoBounds(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}