// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.TokenPruningConfigConverter))]
public sealed partial class TokenPruningConfig
{
#if NET7_0_OR_GREATER
	public TokenPruningConfig()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public TokenPruningConfig()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TokenPruningConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Whether to only score pruned tokens, vs only scoring kept tokens.
	/// </para>
	/// </summary>
	public bool? OnlyScorePrunedTokens { get; set; }

	/// <summary>
	/// <para>
	/// Tokens whose frequency is more than this threshold times the average frequency of all tokens in the specified field are considered outliers and pruned.
	/// </para>
	/// </summary>
	public int? TokensFreqRatioThreshold { get; set; }

	/// <summary>
	/// <para>
	/// Tokens whose weight is less than this threshold are considered nonsignificant and pruned.
	/// </para>
	/// </summary>
	public float? TokensWeightThreshold { get; set; }
}

public readonly partial struct TokenPruningConfigDescriptor
{
	internal Elastic.Clients.Elasticsearch.TokenPruningConfig Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TokenPruningConfigDescriptor(Elastic.Clients.Elasticsearch.TokenPruningConfig instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TokenPruningConfigDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TokenPruningConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor(Elastic.Clients.Elasticsearch.TokenPruningConfig instance) => new Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TokenPruningConfig(Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Whether to only score pruned tokens, vs only scoring kept tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor OnlyScorePrunedTokens(bool? value = true)
	{
		Instance.OnlyScorePrunedTokens = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Tokens whose frequency is more than this threshold times the average frequency of all tokens in the specified field are considered outliers and pruned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor TokensFreqRatioThreshold(int? value)
	{
		Instance.TokensFreqRatioThreshold = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Tokens whose weight is less than this threshold are considered nonsignificant and pruned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor TokensWeightThreshold(float? value)
	{
		Instance.TokensWeightThreshold = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TokenPruningConfig Build(System.Action<Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.TokenPruningConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor(new Elastic.Clients.Elasticsearch.TokenPruningConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}