// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class TimeUnitConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.TimeUnit>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDays = System.Text.Json.JsonEncodedText.Encode("d");
	private static readonly System.Text.Json.JsonEncodedText MemberHours = System.Text.Json.JsonEncodedText.Encode("h");
	private static readonly System.Text.Json.JsonEncodedText MemberMinutes = System.Text.Json.JsonEncodedText.Encode("m");
	private static readonly System.Text.Json.JsonEncodedText MemberMicroseconds = System.Text.Json.JsonEncodedText.Encode("micros");
	private static readonly System.Text.Json.JsonEncodedText MemberMilliseconds = System.Text.Json.JsonEncodedText.Encode("ms");
	private static readonly System.Text.Json.JsonEncodedText MemberNanoseconds = System.Text.Json.JsonEncodedText.Encode("nanos");
	private static readonly System.Text.Json.JsonEncodedText MemberSeconds = System.Text.Json.JsonEncodedText.Encode("s");

	public override Elastic.Clients.Elasticsearch.TimeUnit Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDays))
		{
			return Elastic.Clients.Elasticsearch.TimeUnit.Days;
		}

		if (reader.ValueTextEquals(MemberHours))
		{
			return Elastic.Clients.Elasticsearch.TimeUnit.Hours;
		}

		if (reader.ValueTextEquals(MemberMinutes))
		{
			return Elastic.Clients.Elasticsearch.TimeUnit.Minutes;
		}

		if (reader.ValueTextEquals(MemberMicroseconds))
		{
			return Elastic.Clients.Elasticsearch.TimeUnit.Microseconds;
		}

		if (reader.ValueTextEquals(MemberMilliseconds))
		{
			return Elastic.Clients.Elasticsearch.TimeUnit.Milliseconds;
		}

		if (reader.ValueTextEquals(MemberNanoseconds))
		{
			return Elastic.Clients.Elasticsearch.TimeUnit.Nanoseconds;
		}

		if (reader.ValueTextEquals(MemberSeconds))
		{
			return Elastic.Clients.Elasticsearch.TimeUnit.Seconds;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDays.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.TimeUnit.Days;
		}

		if (string.Equals(value, MemberHours.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.TimeUnit.Hours;
		}

		if (string.Equals(value, MemberMinutes.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.TimeUnit.Minutes;
		}

		if (string.Equals(value, MemberMicroseconds.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.TimeUnit.Microseconds;
		}

		if (string.Equals(value, MemberMilliseconds.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.TimeUnit.Milliseconds;
		}

		if (string.Equals(value, MemberNanoseconds.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.TimeUnit.Nanoseconds;
		}

		if (string.Equals(value, MemberSeconds.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.TimeUnit.Seconds;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.TimeUnit)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.TimeUnit value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.TimeUnit.Days:
				writer.WriteStringValue(MemberDays);
				break;
			case Elastic.Clients.Elasticsearch.TimeUnit.Hours:
				writer.WriteStringValue(MemberHours);
				break;
			case Elastic.Clients.Elasticsearch.TimeUnit.Minutes:
				writer.WriteStringValue(MemberMinutes);
				break;
			case Elastic.Clients.Elasticsearch.TimeUnit.Microseconds:
				writer.WriteStringValue(MemberMicroseconds);
				break;
			case Elastic.Clients.Elasticsearch.TimeUnit.Milliseconds:
				writer.WriteStringValue(MemberMilliseconds);
				break;
			case Elastic.Clients.Elasticsearch.TimeUnit.Nanoseconds:
				writer.WriteStringValue(MemberNanoseconds);
				break;
			case Elastic.Clients.Elasticsearch.TimeUnit.Seconds:
				writer.WriteStringValue(MemberSeconds);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.TimeUnit)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.TimeUnit ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.TimeUnit value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}