// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class ThreadTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.ThreadType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberBlock = System.Text.Json.JsonEncodedText.Encode("block");
	private static readonly System.Text.Json.JsonEncodedText MemberCpu = System.Text.Json.JsonEncodedText.Encode("cpu");
	private static readonly System.Text.Json.JsonEncodedText MemberGpu = System.Text.Json.JsonEncodedText.Encode("gpu");
	private static readonly System.Text.Json.JsonEncodedText MemberMem = System.Text.Json.JsonEncodedText.Encode("mem");
	private static readonly System.Text.Json.JsonEncodedText MemberWait = System.Text.Json.JsonEncodedText.Encode("wait");

	public override Elastic.Clients.Elasticsearch.ThreadType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberBlock))
		{
			return Elastic.Clients.Elasticsearch.ThreadType.Block;
		}

		if (reader.ValueTextEquals(MemberCpu))
		{
			return Elastic.Clients.Elasticsearch.ThreadType.Cpu;
		}

		if (reader.ValueTextEquals(MemberGpu))
		{
			return Elastic.Clients.Elasticsearch.ThreadType.Gpu;
		}

		if (reader.ValueTextEquals(MemberMem))
		{
			return Elastic.Clients.Elasticsearch.ThreadType.Mem;
		}

		if (reader.ValueTextEquals(MemberWait))
		{
			return Elastic.Clients.Elasticsearch.ThreadType.Wait;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberBlock.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.ThreadType.Block;
		}

		if (string.Equals(value, MemberCpu.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.ThreadType.Cpu;
		}

		if (string.Equals(value, MemberGpu.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.ThreadType.Gpu;
		}

		if (string.Equals(value, MemberMem.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.ThreadType.Mem;
		}

		if (string.Equals(value, MemberWait.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.ThreadType.Wait;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.ThreadType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.ThreadType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.ThreadType.Block:
				writer.WriteStringValue(MemberBlock);
				break;
			case Elastic.Clients.Elasticsearch.ThreadType.Cpu:
				writer.WriteStringValue(MemberCpu);
				break;
			case Elastic.Clients.Elasticsearch.ThreadType.Gpu:
				writer.WriteStringValue(MemberGpu);
				break;
			case Elastic.Clients.Elasticsearch.ThreadType.Mem:
				writer.WriteStringValue(MemberMem);
				break;
			case Elastic.Clients.Elasticsearch.ThreadType.Wait:
				writer.WriteStringValue(MemberWait);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.ThreadType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.ThreadType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.ThreadType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}