// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TextStructure.Json;

public sealed partial class FormatTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.TextStructure.FormatType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDelimited = System.Text.Json.JsonEncodedText.Encode("delimited");
	private static readonly System.Text.Json.JsonEncodedText MemberNdjson = System.Text.Json.JsonEncodedText.Encode("ndjson");
	private static readonly System.Text.Json.JsonEncodedText MemberSemiStructuredText = System.Text.Json.JsonEncodedText.Encode("semi_structured_text");
	private static readonly System.Text.Json.JsonEncodedText MemberXml = System.Text.Json.JsonEncodedText.Encode("xml");

	public override Elastic.Clients.Elasticsearch.TextStructure.FormatType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDelimited))
		{
			return Elastic.Clients.Elasticsearch.TextStructure.FormatType.Delimited;
		}

		if (reader.ValueTextEquals(MemberNdjson))
		{
			return Elastic.Clients.Elasticsearch.TextStructure.FormatType.Ndjson;
		}

		if (reader.ValueTextEquals(MemberSemiStructuredText))
		{
			return Elastic.Clients.Elasticsearch.TextStructure.FormatType.SemiStructuredText;
		}

		if (reader.ValueTextEquals(MemberXml))
		{
			return Elastic.Clients.Elasticsearch.TextStructure.FormatType.Xml;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDelimited.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.TextStructure.FormatType.Delimited;
		}

		if (string.Equals(value, MemberNdjson.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.TextStructure.FormatType.Ndjson;
		}

		if (string.Equals(value, MemberSemiStructuredText.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.TextStructure.FormatType.SemiStructuredText;
		}

		if (string.Equals(value, MemberXml.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.TextStructure.FormatType.Xml;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.TextStructure.FormatType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.TextStructure.FormatType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.TextStructure.FormatType.Delimited:
				writer.WriteStringValue(MemberDelimited);
				break;
			case Elastic.Clients.Elasticsearch.TextStructure.FormatType.Ndjson:
				writer.WriteStringValue(MemberNdjson);
				break;
			case Elastic.Clients.Elasticsearch.TextStructure.FormatType.SemiStructuredText:
				writer.WriteStringValue(MemberSemiStructuredText);
				break;
			case Elastic.Clients.Elasticsearch.TextStructure.FormatType.Xml:
				writer.WriteStringValue(MemberXml);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.TextStructure.FormatType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.TextStructure.FormatType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.TextStructure.FormatType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}