// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TextStructure.Json;

public sealed partial class FieldStatConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.TextStructure.FieldStat>
{
	private static readonly System.Text.Json.JsonEncodedText PropCardinality = System.Text.Json.JsonEncodedText.Encode("cardinality");
	private static readonly System.Text.Json.JsonEncodedText PropCount = System.Text.Json.JsonEncodedText.Encode("count");
	private static readonly System.Text.Json.JsonEncodedText PropEarliest = System.Text.Json.JsonEncodedText.Encode("earliest");
	private static readonly System.Text.Json.JsonEncodedText PropLatest = System.Text.Json.JsonEncodedText.Encode("latest");
	private static readonly System.Text.Json.JsonEncodedText PropMaxValue = System.Text.Json.JsonEncodedText.Encode("max_value");
	private static readonly System.Text.Json.JsonEncodedText PropMeanValue = System.Text.Json.JsonEncodedText.Encode("mean_value");
	private static readonly System.Text.Json.JsonEncodedText PropMedianValue = System.Text.Json.JsonEncodedText.Encode("median_value");
	private static readonly System.Text.Json.JsonEncodedText PropMinValue = System.Text.Json.JsonEncodedText.Encode("min_value");
	private static readonly System.Text.Json.JsonEncodedText PropTopHits = System.Text.Json.JsonEncodedText.Encode("top_hits");

	public override Elastic.Clients.Elasticsearch.TextStructure.FieldStat Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propCardinality = default;
		LocalJsonValue<int> propCount = default;
		LocalJsonValue<string?> propEarliest = default;
		LocalJsonValue<string?> propLatest = default;
		LocalJsonValue<int?> propMaxValue = default;
		LocalJsonValue<int?> propMeanValue = default;
		LocalJsonValue<int?> propMedianValue = default;
		LocalJsonValue<int?> propMinValue = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.TextStructure.TopHit>> propTopHits = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propCardinality.TryReadProperty(ref reader, options, PropCardinality, null))
			{
				continue;
			}

			if (propCount.TryReadProperty(ref reader, options, PropCount, null))
			{
				continue;
			}

			if (propEarliest.TryReadProperty(ref reader, options, PropEarliest, null))
			{
				continue;
			}

			if (propLatest.TryReadProperty(ref reader, options, PropLatest, null))
			{
				continue;
			}

			if (propMaxValue.TryReadProperty(ref reader, options, PropMaxValue, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMeanValue.TryReadProperty(ref reader, options, PropMeanValue, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMedianValue.TryReadProperty(ref reader, options, PropMedianValue, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMinValue.TryReadProperty(ref reader, options, PropMinValue, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propTopHits.TryReadProperty(ref reader, options, PropTopHits, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.TextStructure.TopHit> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.TextStructure.TopHit>(o, null)!))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.TextStructure.FieldStat(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Cardinality = propCardinality.Value,
			Count = propCount.Value,
			Earliest = propEarliest.Value,
			Latest = propLatest.Value,
			MaxValue = propMaxValue.Value,
			MeanValue = propMeanValue.Value,
			MedianValue = propMedianValue.Value,
			MinValue = propMinValue.Value,
			TopHits = propTopHits.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.TextStructure.FieldStat value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropCardinality, value.Cardinality, null, null);
		writer.WriteProperty(options, PropCount, value.Count, null, null);
		writer.WriteProperty(options, PropEarliest, value.Earliest, null, null);
		writer.WriteProperty(options, PropLatest, value.Latest, null, null);
		writer.WriteProperty(options, PropMaxValue, value.MaxValue, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMeanValue, value.MeanValue, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMedianValue, value.MedianValue, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMinValue, value.MinValue, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropTopHits, value.TopHits, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.TextStructure.TopHit> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.TextStructure.TopHit>(o, v, null));
		writer.WriteEndObject();
	}
}