// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TextStructure.Json;

public sealed partial class EcsCompatibilityTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.TextStructure.EcsCompatibilityType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDisabled = System.Text.Json.JsonEncodedText.Encode("disabled");
	private static readonly System.Text.Json.JsonEncodedText MemberV1 = System.Text.Json.JsonEncodedText.Encode("v1");

	public override Elastic.Clients.Elasticsearch.TextStructure.EcsCompatibilityType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDisabled))
		{
			return Elastic.Clients.Elasticsearch.TextStructure.EcsCompatibilityType.Disabled;
		}

		if (reader.ValueTextEquals(MemberV1))
		{
			return Elastic.Clients.Elasticsearch.TextStructure.EcsCompatibilityType.V1;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDisabled.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.TextStructure.EcsCompatibilityType.Disabled;
		}

		if (string.Equals(value, MemberV1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.TextStructure.EcsCompatibilityType.V1;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.TextStructure.EcsCompatibilityType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.TextStructure.EcsCompatibilityType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.TextStructure.EcsCompatibilityType.Disabled:
				writer.WriteStringValue(MemberDisabled);
				break;
			case Elastic.Clients.Elasticsearch.TextStructure.EcsCompatibilityType.V1:
				writer.WriteStringValue(MemberV1);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.TextStructure.EcsCompatibilityType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.TextStructure.EcsCompatibilityType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.TextStructure.EcsCompatibilityType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}