// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.TextEmbeddingConverter))]
public sealed partial class TextEmbedding
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TextEmbedding(string modelText)
	{
		ModelText = modelText;
	}
#if NET7_0_OR_GREATER
	public TextEmbedding()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TextEmbedding()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TextEmbedding(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Model ID is required for all dense_vector fields but
	/// may be inferred for semantic_text fields
	/// </para>
	/// </summary>
	public string? ModelId { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ModelText { get; set; }
}

public readonly partial struct TextEmbeddingDescriptor
{
	internal Elastic.Clients.Elasticsearch.TextEmbedding Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TextEmbeddingDescriptor(Elastic.Clients.Elasticsearch.TextEmbedding instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TextEmbeddingDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TextEmbedding(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TextEmbeddingDescriptor(Elastic.Clients.Elasticsearch.TextEmbedding instance) => new Elastic.Clients.Elasticsearch.TextEmbeddingDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TextEmbedding(Elastic.Clients.Elasticsearch.TextEmbeddingDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Model ID is required for all dense_vector fields but
	/// may be inferred for semantic_text fields
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TextEmbeddingDescriptor ModelId(string? value)
	{
		Instance.ModelId = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TextEmbeddingDescriptor ModelText(string value)
	{
		Instance.ModelText = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TextEmbedding Build(System.Action<Elastic.Clients.Elasticsearch.TextEmbeddingDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TextEmbeddingDescriptor(new Elastic.Clients.Elasticsearch.TextEmbedding(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}