// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Tasks;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Tasks.Json.TaskInfoConverter))]
public sealed partial class TaskInfo
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TaskInfo(string action, bool cancellable, System.Collections.Generic.IReadOnlyDictionary<string, string> headers, long id, string node, System.TimeSpan runningTimeInNanos, System.DateTimeOffset startTimeInMillis, string type)
	{
		Action = action;
		Cancellable = cancellable;
		Headers = headers;
		Id = id;
		Node = node;
		RunningTimeInNanos = runningTimeInNanos;
		StartTimeInMillis = startTimeInMillis;
		Type = type;
	}
#if NET7_0_OR_GREATER
	public TaskInfo()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TaskInfo()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TaskInfo(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	string Action { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool Cancellable { get; set; }
	public bool? Cancelled { get; set; }

	/// <summary>
	/// <para>
	/// Human readable text that identifies the particular request that the task is performing.
	/// For example, it might identify the search request being performed by a search task.
	/// Other kinds of tasks have different descriptions, like <c>_reindex</c> which has the source and the destination, or <c>_bulk</c> which just has the number of requests and the destination indices.
	/// Many requests will have only an empty description because more detailed information about the request is not easily available or particularly helpful in identifying the request.
	/// </para>
	/// </summary>
	public string? Description { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, string> Headers { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Id { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Node { get; set; }
	public Elastic.Clients.Elasticsearch.TaskId? ParentTaskId { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? RunningTime { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan RunningTimeInNanos { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset StartTimeInMillis { get; set; }

	/// <summary>
	/// <para>
	/// The internal status of the task, which varies from task to task.
	/// The format also varies.
	/// While the goal is to keep the status for a particular task consistent from version to version, this is not always possible because sometimes the implementation changes.
	/// Fields might be removed from the status for a particular request so any parsing you do of the status might break in minor releases.
	/// </para>
	/// </summary>
	public object? Status { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Type { get; set; }
}