// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Synonyms;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Synonyms.Json.SynonymRuleConverter))]
public sealed partial class SynonymRule
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SynonymRule(string synonyms)
	{
		Synonyms = synonyms;
	}
#if NET7_0_OR_GREATER
	public SynonymRule()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SynonymRule()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SynonymRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The identifier for the synonym rule.
	/// If you do not specify a synonym rule ID when you create a rule, an identifier is created automatically by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? Id { get; set; }

	/// <summary>
	/// <para>
	/// The synonyms that conform the synonym rule in Solr format.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Synonyms { get; set; }
}

public readonly partial struct SynonymRuleDescriptor
{
	internal Elastic.Clients.Elasticsearch.Synonyms.SynonymRule Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SynonymRuleDescriptor(Elastic.Clients.Elasticsearch.Synonyms.SynonymRule instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SynonymRuleDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Synonyms.SynonymRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Synonyms.SynonymRuleDescriptor(Elastic.Clients.Elasticsearch.Synonyms.SynonymRule instance) => new Elastic.Clients.Elasticsearch.Synonyms.SynonymRuleDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Synonyms.SynonymRule(Elastic.Clients.Elasticsearch.Synonyms.SynonymRuleDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The identifier for the synonym rule.
	/// If you do not specify a synonym rule ID when you create a rule, an identifier is created automatically by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.SynonymRuleDescriptor Id(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The synonyms that conform the synonym rule in Solr format.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.SynonymRuleDescriptor Synonyms(string value)
	{
		Instance.Synonyms = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Synonyms.SynonymRule Build(System.Action<Elastic.Clients.Elasticsearch.Synonyms.SynonymRuleDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Synonyms.SynonymRuleDescriptor(new Elastic.Clients.Elasticsearch.Synonyms.SynonymRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}