// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class SuggestModeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.SuggestMode>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAlways = System.Text.Json.JsonEncodedText.Encode("always");
	private static readonly System.Text.Json.JsonEncodedText MemberMissing = System.Text.Json.JsonEncodedText.Encode("missing");
	private static readonly System.Text.Json.JsonEncodedText MemberPopular = System.Text.Json.JsonEncodedText.Encode("popular");

	public override Elastic.Clients.Elasticsearch.SuggestMode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAlways))
		{
			return Elastic.Clients.Elasticsearch.SuggestMode.Always;
		}

		if (reader.ValueTextEquals(MemberMissing))
		{
			return Elastic.Clients.Elasticsearch.SuggestMode.Missing;
		}

		if (reader.ValueTextEquals(MemberPopular))
		{
			return Elastic.Clients.Elasticsearch.SuggestMode.Popular;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAlways.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.SuggestMode.Always;
		}

		if (string.Equals(value, MemberMissing.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.SuggestMode.Missing;
		}

		if (string.Equals(value, MemberPopular.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.SuggestMode.Popular;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.SuggestMode)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.SuggestMode value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.SuggestMode.Always:
				writer.WriteStringValue(MemberAlways);
				break;
			case Elastic.Clients.Elasticsearch.SuggestMode.Missing:
				writer.WriteStringValue(MemberMissing);
				break;
			case Elastic.Clients.Elasticsearch.SuggestMode.Popular:
				writer.WriteStringValue(MemberPopular);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.SuggestMode)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.SuggestMode ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.SuggestMode value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}