// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.StoredScriptConverter))]
public sealed partial class StoredScript
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StoredScript(Elastic.Clients.Elasticsearch.ScriptLanguage language, string source)
	{
		Language = language;
		Source = source;
	}
#if NET7_0_OR_GREATER
	public StoredScript()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public StoredScript()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal StoredScript(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The language the script is written in.
	/// For search templates, use <c>mustache</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.ScriptLanguage Language { get; set; }
	public System.Collections.Generic.IDictionary<string, string>? Options { get; set; }

	/// <summary>
	/// <para>
	/// The script source.
	/// For search templates, an object containing the search template.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Source { get; set; }
}

public readonly partial struct StoredScriptDescriptor
{
	internal Elastic.Clients.Elasticsearch.StoredScript Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StoredScriptDescriptor(Elastic.Clients.Elasticsearch.StoredScript instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StoredScriptDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.StoredScript(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.StoredScriptDescriptor(Elastic.Clients.Elasticsearch.StoredScript instance) => new Elastic.Clients.Elasticsearch.StoredScriptDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.StoredScript(Elastic.Clients.Elasticsearch.StoredScriptDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The language the script is written in.
	/// For search templates, use <c>mustache</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.StoredScriptDescriptor Language(Elastic.Clients.Elasticsearch.ScriptLanguage value)
	{
		Instance.Language = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.StoredScriptDescriptor Options(System.Collections.Generic.IDictionary<string, string>? value)
	{
		Instance.Options = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.StoredScriptDescriptor Options()
	{
		Instance.Options = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.StoredScriptDescriptor Options(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString>? action)
	{
		Instance.Options = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.StoredScriptDescriptor AddOption(string key, string value)
	{
		Instance.Options ??= new System.Collections.Generic.Dictionary<string, string>();
		Instance.Options.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// The script source.
	/// For search templates, an object containing the search template.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.StoredScriptDescriptor Source(string value)
	{
		Instance.Source = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.StoredScript Build(System.Action<Elastic.Clients.Elasticsearch.StoredScriptDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.StoredScriptDescriptor(new Elastic.Clients.Elasticsearch.StoredScript(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}