// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.StoreStatsConverter))]
public sealed partial class StoreStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StoreStats(long reservedInBytes, long sizeInBytes)
	{
		ReservedInBytes = reservedInBytes;
		SizeInBytes = sizeInBytes;
	}
#if NET7_0_OR_GREATER
	public StoreStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public StoreStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal StoreStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A prediction of how much larger the shard stores will eventually grow due to ongoing peer recoveries, restoring snapshots, and similar activities.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? Reserved { get; set; }

	/// <summary>
	/// <para>
	/// A prediction, in bytes, of how much larger the shard stores will eventually grow due to ongoing peer recoveries, restoring snapshots, and similar activities.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long ReservedInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total size of all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? Size { get; set; }

	/// <summary>
	/// <para>
	/// Total size, in bytes, of all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long SizeInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total data set size of all shards assigned to selected nodes.
	/// This includes the size of shards not stored fully on the nodes, such as the cache for partially mounted indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? TotalDataSetSize { get; set; }

	/// <summary>
	/// <para>
	/// Total data set size, in bytes, of all shards assigned to selected nodes.
	/// This includes the size of shards not stored fully on the nodes, such as the cache for partially mounted indices.
	/// </para>
	/// </summary>
	public long? TotalDataSetSizeInBytes { get; set; }
}