// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class StoreStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.StoreStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropReserved = System.Text.Json.JsonEncodedText.Encode("reserved");
	private static readonly System.Text.Json.JsonEncodedText PropReservedInBytes = System.Text.Json.JsonEncodedText.Encode("reserved_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropSize = System.Text.Json.JsonEncodedText.Encode("size");
	private static readonly System.Text.Json.JsonEncodedText PropSizeInBytes = System.Text.Json.JsonEncodedText.Encode("size_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropTotalDataSetSize = System.Text.Json.JsonEncodedText.Encode("total_data_set_size");
	private static readonly System.Text.Json.JsonEncodedText PropTotalDataSetSizeInBytes = System.Text.Json.JsonEncodedText.Encode("total_data_set_size_in_bytes");

	public override Elastic.Clients.Elasticsearch.StoreStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propReserved = default;
		LocalJsonValue<long> propReservedInBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propSize = default;
		LocalJsonValue<long> propSizeInBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propTotalDataSetSize = default;
		LocalJsonValue<long?> propTotalDataSetSizeInBytes = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propReserved.TryReadProperty(ref reader, options, PropReserved, null))
			{
				continue;
			}

			if (propReservedInBytes.TryReadProperty(ref reader, options, PropReservedInBytes, null))
			{
				continue;
			}

			if (propSize.TryReadProperty(ref reader, options, PropSize, null))
			{
				continue;
			}

			if (propSizeInBytes.TryReadProperty(ref reader, options, PropSizeInBytes, null))
			{
				continue;
			}

			if (propTotalDataSetSize.TryReadProperty(ref reader, options, PropTotalDataSetSize, null))
			{
				continue;
			}

			if (propTotalDataSetSizeInBytes.TryReadProperty(ref reader, options, PropTotalDataSetSizeInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.StoreStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Reserved = propReserved.Value,
			ReservedInBytes = propReservedInBytes.Value,
			Size = propSize.Value,
			SizeInBytes = propSizeInBytes.Value,
			TotalDataSetSize = propTotalDataSetSize.Value,
			TotalDataSetSizeInBytes = propTotalDataSetSizeInBytes.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.StoreStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropReserved, value.Reserved, null, null);
		writer.WriteProperty(options, PropReservedInBytes, value.ReservedInBytes, null, null);
		writer.WriteProperty(options, PropSize, value.Size, null, null);
		writer.WriteProperty(options, PropSizeInBytes, value.SizeInBytes, null, null);
		writer.WriteProperty(options, PropTotalDataSetSize, value.TotalDataSetSize, null, null);
		writer.WriteProperty(options, PropTotalDataSetSizeInBytes, value.TotalDataSetSizeInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteEndObject();
	}
}