// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.SortOptionsConverter))]
public sealed partial class SortOptions
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public SortOptions()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SortOptions()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SortOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.ScoreSort? Doc { get => GetVariant<Elastic.Clients.Elasticsearch.ScoreSort>("_doc"); set => SetVariant("_doc", value); }
	public Elastic.Clients.Elasticsearch.FieldSort? Field { get => GetVariant<Elastic.Clients.Elasticsearch.FieldSort>(""); set => SetVariant("", value); }
	public Elastic.Clients.Elasticsearch.GeoDistanceSort? GeoDistance { get => GetVariant<Elastic.Clients.Elasticsearch.GeoDistanceSort>("_geo_distance"); set => SetVariant("_geo_distance", value); }
	public Elastic.Clients.Elasticsearch.ScoreSort? Score { get => GetVariant<Elastic.Clients.Elasticsearch.ScoreSort>("_score"); set => SetVariant("_score", value); }
	public Elastic.Clients.Elasticsearch.ScriptSort? Script { get => GetVariant<Elastic.Clients.Elasticsearch.ScriptSort>("_script"); set => SetVariant("_script", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.SortOptions(Elastic.Clients.Elasticsearch.FieldSort value) => new Elastic.Clients.Elasticsearch.SortOptions { Field = value };
	public static implicit operator Elastic.Clients.Elasticsearch.SortOptions(Elastic.Clients.Elasticsearch.GeoDistanceSort value) => new Elastic.Clients.Elasticsearch.SortOptions { GeoDistance = value };
	public static implicit operator Elastic.Clients.Elasticsearch.SortOptions(Elastic.Clients.Elasticsearch.ScriptSort value) => new Elastic.Clients.Elasticsearch.SortOptions { Script = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct SortOptionsDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.SortOptions Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SortOptionsDescriptor(Elastic.Clients.Elasticsearch.SortOptions instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SortOptionsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.SortOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>(Elastic.Clients.Elasticsearch.SortOptions instance) => new Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.SortOptions(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument> Doc(Elastic.Clients.Elasticsearch.ScoreSort? value)
	{
		Instance.Doc = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument> Doc()
	{
		Instance.Doc = Elastic.Clients.Elasticsearch.ScoreSortDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument> Doc(System.Action<Elastic.Clients.Elasticsearch.ScoreSortDescriptor>? action)
	{
		Instance.Doc = Elastic.Clients.Elasticsearch.ScoreSortDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.FieldSort? value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument> Field(System.Action<Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument>> action)
	{
		Instance.Field = Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument> GeoDistance(Elastic.Clients.Elasticsearch.GeoDistanceSort? value)
	{
		Instance.GeoDistance = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument> GeoDistance(System.Action<Elastic.Clients.Elasticsearch.GeoDistanceSortDescriptor<TDocument>> action)
	{
		Instance.GeoDistance = Elastic.Clients.Elasticsearch.GeoDistanceSortDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument> Score(Elastic.Clients.Elasticsearch.ScoreSort? value)
	{
		Instance.Score = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument> Score()
	{
		Instance.Score = Elastic.Clients.Elasticsearch.ScoreSortDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument> Score(System.Action<Elastic.Clients.Elasticsearch.ScoreSortDescriptor>? action)
	{
		Instance.Score = Elastic.Clients.Elasticsearch.ScoreSortDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.ScriptSort? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptSortDescriptor<TDocument>> action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptSortDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.SortOptions Build(System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.SortOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct SortOptionsDescriptor
{
	internal Elastic.Clients.Elasticsearch.SortOptions Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SortOptionsDescriptor(Elastic.Clients.Elasticsearch.SortOptions instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SortOptionsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.SortOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.SortOptionsDescriptor(Elastic.Clients.Elasticsearch.SortOptions instance) => new Elastic.Clients.Elasticsearch.SortOptionsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.SortOptions(Elastic.Clients.Elasticsearch.SortOptionsDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor Doc(Elastic.Clients.Elasticsearch.ScoreSort? value)
	{
		Instance.Doc = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor Doc()
	{
		Instance.Doc = Elastic.Clients.Elasticsearch.ScoreSortDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor Doc(System.Action<Elastic.Clients.Elasticsearch.ScoreSortDescriptor>? action)
	{
		Instance.Doc = Elastic.Clients.Elasticsearch.ScoreSortDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor Field(Elastic.Clients.Elasticsearch.FieldSort? value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor Field(System.Action<Elastic.Clients.Elasticsearch.FieldSortDescriptor> action)
	{
		Instance.Field = Elastic.Clients.Elasticsearch.FieldSortDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor Field<T>(System.Action<Elastic.Clients.Elasticsearch.FieldSortDescriptor<T>> action)
	{
		Instance.Field = Elastic.Clients.Elasticsearch.FieldSortDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor GeoDistance(Elastic.Clients.Elasticsearch.GeoDistanceSort? value)
	{
		Instance.GeoDistance = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor GeoDistance(System.Action<Elastic.Clients.Elasticsearch.GeoDistanceSortDescriptor> action)
	{
		Instance.GeoDistance = Elastic.Clients.Elasticsearch.GeoDistanceSortDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor GeoDistance<T>(System.Action<Elastic.Clients.Elasticsearch.GeoDistanceSortDescriptor<T>> action)
	{
		Instance.GeoDistance = Elastic.Clients.Elasticsearch.GeoDistanceSortDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor Score(Elastic.Clients.Elasticsearch.ScoreSort? value)
	{
		Instance.Score = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor Score()
	{
		Instance.Score = Elastic.Clients.Elasticsearch.ScoreSortDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor Score(System.Action<Elastic.Clients.Elasticsearch.ScoreSortDescriptor>? action)
	{
		Instance.Score = Elastic.Clients.Elasticsearch.ScoreSortDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor Script(Elastic.Clients.Elasticsearch.ScriptSort? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptSortDescriptor> action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptSortDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SortOptionsDescriptor Script<T>(System.Action<Elastic.Clients.Elasticsearch.ScriptSortDescriptor<T>> action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptSortDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.SortOptions Build(System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.SortOptionsDescriptor(new Elastic.Clients.Elasticsearch.SortOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}