// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class SortOptionsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.SortOptions>
{
	private static readonly System.Text.Json.JsonEncodedText VariantDoc = System.Text.Json.JsonEncodedText.Encode("_doc");
	private static readonly System.Text.Json.JsonEncodedText VariantGeoDistance = System.Text.Json.JsonEncodedText.Encode("_geo_distance");
	private static readonly System.Text.Json.JsonEncodedText VariantScore = System.Text.Json.JsonEncodedText.Encode("_score");
	private static readonly System.Text.Json.JsonEncodedText VariantScript = System.Text.Json.JsonEncodedText.Encode("_script");

	public override Elastic.Clients.Elasticsearch.SortOptions Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.TokenType is System.Text.Json.JsonTokenType.String)
		{
			return new Elastic.Clients.Elasticsearch.SortOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
			{
				VariantType = "",
				Variant = new Elastic.Clients.Elasticsearch.FieldSort(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
				{
					Field = reader.ReadValue<Elastic.Clients.Elasticsearch.Field>(options, null)
				}
			};
		}

		var readerSnapshot = reader;
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.ValueTextEquals(VariantDoc))
			{
				variantType = VariantDoc.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.ScoreSort>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeoDistance))
			{
				variantType = VariantGeoDistance.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.GeoDistanceSort>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantScore))
			{
				variantType = VariantScore.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.ScoreSort>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantScript))
			{
				variantType = VariantScript.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.ScriptSort>(options, null);
				continue;
			}

			reader = readerSnapshot;
			variantType = "";
			variant = reader.ReadValue<Elastic.Clients.Elasticsearch.FieldSort>(options, null);
			break;
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.SortOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.SortOptions value, System.Text.Json.JsonSerializerOptions options)
	{
		if (value.VariantType is "" && value.Variant is not null)
		{
			writer.WriteValue(options, (Elastic.Clients.Elasticsearch.FieldSort)value.Variant, null);
			return;
		}

		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "_doc":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.ScoreSort)value.Variant, null, null);
				break;
			case "_geo_distance":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.GeoDistanceSort)value.Variant, null, null);
				break;
			case "_score":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.ScoreSort)value.Variant, null, null);
				break;
			case "_script":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.ScriptSort)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.SortOptions)}'.");
		}

		writer.WriteEndObject();
	}
}