// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class SortModeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.SortMode>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAvg = System.Text.Json.JsonEncodedText.Encode("avg");
	private static readonly System.Text.Json.JsonEncodedText MemberMax = System.Text.Json.JsonEncodedText.Encode("max");
	private static readonly System.Text.Json.JsonEncodedText MemberMedian = System.Text.Json.JsonEncodedText.Encode("median");
	private static readonly System.Text.Json.JsonEncodedText MemberMin = System.Text.Json.JsonEncodedText.Encode("min");
	private static readonly System.Text.Json.JsonEncodedText MemberSum = System.Text.Json.JsonEncodedText.Encode("sum");

	public override Elastic.Clients.Elasticsearch.SortMode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAvg))
		{
			return Elastic.Clients.Elasticsearch.SortMode.Avg;
		}

		if (reader.ValueTextEquals(MemberMax))
		{
			return Elastic.Clients.Elasticsearch.SortMode.Max;
		}

		if (reader.ValueTextEquals(MemberMedian))
		{
			return Elastic.Clients.Elasticsearch.SortMode.Median;
		}

		if (reader.ValueTextEquals(MemberMin))
		{
			return Elastic.Clients.Elasticsearch.SortMode.Min;
		}

		if (reader.ValueTextEquals(MemberSum))
		{
			return Elastic.Clients.Elasticsearch.SortMode.Sum;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAvg.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.SortMode.Avg;
		}

		if (string.Equals(value, MemberMax.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.SortMode.Max;
		}

		if (string.Equals(value, MemberMedian.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.SortMode.Median;
		}

		if (string.Equals(value, MemberMin.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.SortMode.Min;
		}

		if (string.Equals(value, MemberSum.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.SortMode.Sum;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.SortMode)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.SortMode value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.SortMode.Avg:
				writer.WriteStringValue(MemberAvg);
				break;
			case Elastic.Clients.Elasticsearch.SortMode.Max:
				writer.WriteStringValue(MemberMax);
				break;
			case Elastic.Clients.Elasticsearch.SortMode.Median:
				writer.WriteStringValue(MemberMedian);
				break;
			case Elastic.Clients.Elasticsearch.SortMode.Min:
				writer.WriteStringValue(MemberMin);
				break;
			case Elastic.Clients.Elasticsearch.SortMode.Sum:
				writer.WriteStringValue(MemberSum);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.SortMode)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.SortMode ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.SortMode value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}