// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Json;

public sealed partial class StatisticsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Statistics>
{
	private static readonly System.Text.Json.JsonEncodedText PropPolicy = System.Text.Json.JsonEncodedText.Encode("policy");
	private static readonly System.Text.Json.JsonEncodedText PropRetentionDeletionTime = System.Text.Json.JsonEncodedText.Encode("retention_deletion_time");
	private static readonly System.Text.Json.JsonEncodedText PropRetentionDeletionTimeMillis = System.Text.Json.JsonEncodedText.Encode("retention_deletion_time_millis");
	private static readonly System.Text.Json.JsonEncodedText PropRetentionFailed = System.Text.Json.JsonEncodedText.Encode("retention_failed");
	private static readonly System.Text.Json.JsonEncodedText PropRetentionRuns = System.Text.Json.JsonEncodedText.Encode("retention_runs");
	private static readonly System.Text.Json.JsonEncodedText PropRetentionTimedOut = System.Text.Json.JsonEncodedText.Encode("retention_timed_out");
	private static readonly System.Text.Json.JsonEncodedText PropTotalSnapshotDeletionFailures = System.Text.Json.JsonEncodedText.Encode("total_snapshot_deletion_failures");
	private static readonly System.Text.Json.JsonEncodedText PropTotalSnapshotDeletionFailures1 = System.Text.Json.JsonEncodedText.Encode("snapshot_deletion_failures");
	private static readonly System.Text.Json.JsonEncodedText PropTotalSnapshotsDeleted = System.Text.Json.JsonEncodedText.Encode("total_snapshots_deleted");
	private static readonly System.Text.Json.JsonEncodedText PropTotalSnapshotsDeleted1 = System.Text.Json.JsonEncodedText.Encode("snapshots_deleted");
	private static readonly System.Text.Json.JsonEncodedText PropTotalSnapshotsFailed = System.Text.Json.JsonEncodedText.Encode("total_snapshots_failed");
	private static readonly System.Text.Json.JsonEncodedText PropTotalSnapshotsFailed1 = System.Text.Json.JsonEncodedText.Encode("snapshots_failed");
	private static readonly System.Text.Json.JsonEncodedText PropTotalSnapshotsTaken = System.Text.Json.JsonEncodedText.Encode("total_snapshots_taken");
	private static readonly System.Text.Json.JsonEncodedText PropTotalSnapshotsTaken1 = System.Text.Json.JsonEncodedText.Encode("snapshots_taken");

	public override Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Statistics Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propPolicy = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propRetentionDeletionTime = default;
		LocalJsonValue<System.TimeSpan?> propRetentionDeletionTimeMillis = default;
		LocalJsonValue<long?> propRetentionFailed = default;
		LocalJsonValue<long?> propRetentionRuns = default;
		LocalJsonValue<long?> propRetentionTimedOut = default;
		LocalJsonValue<long?> propTotalSnapshotDeletionFailures = default;
		LocalJsonValue<long?> propTotalSnapshotsDeleted = default;
		LocalJsonValue<long?> propTotalSnapshotsFailed = default;
		LocalJsonValue<long?> propTotalSnapshotsTaken = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propPolicy.TryReadProperty(ref reader, options, PropPolicy, null))
			{
				continue;
			}

			if (propRetentionDeletionTime.TryReadProperty(ref reader, options, PropRetentionDeletionTime, null))
			{
				continue;
			}

			if (propRetentionDeletionTimeMillis.TryReadProperty(ref reader, options, PropRetentionDeletionTimeMillis, static System.TimeSpan? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propRetentionFailed.TryReadProperty(ref reader, options, PropRetentionFailed, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propRetentionRuns.TryReadProperty(ref reader, options, PropRetentionRuns, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propRetentionTimedOut.TryReadProperty(ref reader, options, PropRetentionTimedOut, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propTotalSnapshotDeletionFailures.TryReadProperty(ref reader, options, PropTotalSnapshotDeletionFailures, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)) || propTotalSnapshotDeletionFailures.TryReadProperty(ref reader, options, PropTotalSnapshotDeletionFailures1, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propTotalSnapshotsDeleted.TryReadProperty(ref reader, options, PropTotalSnapshotsDeleted, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)) || propTotalSnapshotsDeleted.TryReadProperty(ref reader, options, PropTotalSnapshotsDeleted1, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propTotalSnapshotsFailed.TryReadProperty(ref reader, options, PropTotalSnapshotsFailed, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)) || propTotalSnapshotsFailed.TryReadProperty(ref reader, options, PropTotalSnapshotsFailed1, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propTotalSnapshotsTaken.TryReadProperty(ref reader, options, PropTotalSnapshotsTaken, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)) || propTotalSnapshotsTaken.TryReadProperty(ref reader, options, PropTotalSnapshotsTaken1, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Statistics(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Policy = propPolicy.Value,
			RetentionDeletionTime = propRetentionDeletionTime.Value,
			RetentionDeletionTimeMillis = propRetentionDeletionTimeMillis.Value,
			RetentionFailed = propRetentionFailed.Value,
			RetentionRuns = propRetentionRuns.Value,
			RetentionTimedOut = propRetentionTimedOut.Value,
			TotalSnapshotDeletionFailures = propTotalSnapshotDeletionFailures.Value,
			TotalSnapshotsDeleted = propTotalSnapshotsDeleted.Value,
			TotalSnapshotsFailed = propTotalSnapshotsFailed.Value,
			TotalSnapshotsTaken = propTotalSnapshotsTaken.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Statistics value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropPolicy, value.Policy, null, null);
		writer.WriteProperty(options, PropRetentionDeletionTime, value.RetentionDeletionTime, null, null);
		writer.WriteProperty(options, PropRetentionDeletionTimeMillis, value.RetentionDeletionTimeMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan? v) => w.WriteNullableValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropRetentionFailed, value.RetentionFailed, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropRetentionRuns, value.RetentionRuns, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropRetentionTimedOut, value.RetentionTimedOut, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropTotalSnapshotDeletionFailures, value.TotalSnapshotDeletionFailures, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropTotalSnapshotsDeleted, value.TotalSnapshotsDeleted, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropTotalSnapshotsFailed, value.TotalSnapshotsFailed, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropTotalSnapshotsTaken, value.TotalSnapshotsTaken, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteEndObject();
	}
}