// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Json;

public sealed partial class SnapshotPolicyStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.SnapshotPolicyStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropPolicy = System.Text.Json.JsonEncodedText.Encode("policy");
	private static readonly System.Text.Json.JsonEncodedText PropSnapshotDeletionFailures = System.Text.Json.JsonEncodedText.Encode("snapshot_deletion_failures");
	private static readonly System.Text.Json.JsonEncodedText PropSnapshotsDeleted = System.Text.Json.JsonEncodedText.Encode("snapshots_deleted");
	private static readonly System.Text.Json.JsonEncodedText PropSnapshotsFailed = System.Text.Json.JsonEncodedText.Encode("snapshots_failed");
	private static readonly System.Text.Json.JsonEncodedText PropSnapshotsTaken = System.Text.Json.JsonEncodedText.Encode("snapshots_taken");

	public override Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.SnapshotPolicyStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string> propPolicy = default;
		LocalJsonValue<long> propSnapshotDeletionFailures = default;
		LocalJsonValue<long> propSnapshotsDeleted = default;
		LocalJsonValue<long> propSnapshotsFailed = default;
		LocalJsonValue<long> propSnapshotsTaken = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propPolicy.TryReadProperty(ref reader, options, PropPolicy, null))
			{
				continue;
			}

			if (propSnapshotDeletionFailures.TryReadProperty(ref reader, options, PropSnapshotDeletionFailures, null))
			{
				continue;
			}

			if (propSnapshotsDeleted.TryReadProperty(ref reader, options, PropSnapshotsDeleted, null))
			{
				continue;
			}

			if (propSnapshotsFailed.TryReadProperty(ref reader, options, PropSnapshotsFailed, null))
			{
				continue;
			}

			if (propSnapshotsTaken.TryReadProperty(ref reader, options, PropSnapshotsTaken, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.SnapshotPolicyStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Policy = propPolicy.Value,
			SnapshotDeletionFailures = propSnapshotDeletionFailures.Value,
			SnapshotsDeleted = propSnapshotsDeleted.Value,
			SnapshotsFailed = propSnapshotsFailed.Value,
			SnapshotsTaken = propSnapshotsTaken.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.SnapshotPolicyStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropPolicy, value.Policy, null, null);
		writer.WriteProperty(options, PropSnapshotDeletionFailures, value.SnapshotDeletionFailures, null, null);
		writer.WriteProperty(options, PropSnapshotsDeleted, value.SnapshotsDeleted, null, null);
		writer.WriteProperty(options, PropSnapshotsFailed, value.SnapshotsFailed, null, null);
		writer.WriteProperty(options, PropSnapshotsTaken, value.SnapshotsTaken, null, null);
		writer.WriteEndObject();
	}
}