// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Json.SnapshotLifecycleConverter))]
public sealed partial class SnapshotLifecycle
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SnapshotLifecycle(System.DateTimeOffset modifiedDateMillis, System.DateTimeOffset nextExecutionMillis, Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.SlmPolicy policy, Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Statistics stats, long version)
	{
		ModifiedDateMillis = modifiedDateMillis;
		NextExecutionMillis = nextExecutionMillis;
		Policy = policy;
		Stats = stats;
		Version = version;
	}
#if NET7_0_OR_GREATER
	public SnapshotLifecycle()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SnapshotLifecycle()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SnapshotLifecycle(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.InProgress? InProgress { get; set; }
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Invocation? LastFailure { get; set; }
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Invocation? LastSuccess { get; set; }

	/// <summary>
	/// <para>
	/// The last time the policy was modified.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? ModifiedDate { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset ModifiedDateMillis { get; set; }

	/// <summary>
	/// <para>
	/// The next time the policy will run.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? NextExecution { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset NextExecutionMillis { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.SlmPolicy Policy { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Statistics Stats { get; set; }

	/// <summary>
	/// <para>
	/// The version of the snapshot policy.
	/// Only the latest version is stored and incremented when the policy is updated.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Version { get; set; }
}