// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Json.RetentionConverter))]
public sealed partial class Retention
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public Retention(Elastic.Clients.Elasticsearch.Duration expireAfter, int maxCount, int minCount)
	{
		ExpireAfter = expireAfter;
		MaxCount = maxCount;
		MinCount = minCount;
	}
#if NET7_0_OR_GREATER
	public Retention()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public Retention()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Retention(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Time period after which a snapshot is considered expired and eligible for deletion. SLM deletes expired snapshots based on the slm.retention_schedule.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Duration ExpireAfter { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of snapshots to retain, even if the snapshots have not yet expired. If the number of snapshots in the repository exceeds this limit, the policy retains the most recent snapshots and deletes older snapshots.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int MaxCount { get; set; }

	/// <summary>
	/// <para>
	/// Minimum number of snapshots to retain, even if the snapshots have expired.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int MinCount { get; set; }
}

public readonly partial struct RetentionDescriptor
{
	internal Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Retention Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RetentionDescriptor(Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Retention instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RetentionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Retention(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.RetentionDescriptor(Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Retention instance) => new Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.RetentionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Retention(Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.RetentionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Time period after which a snapshot is considered expired and eligible for deletion. SLM deletes expired snapshots based on the slm.retention_schedule.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.RetentionDescriptor ExpireAfter(Elastic.Clients.Elasticsearch.Duration value)
	{
		Instance.ExpireAfter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of snapshots to retain, even if the snapshots have not yet expired. If the number of snapshots in the repository exceeds this limit, the policy retains the most recent snapshots and deletes older snapshots.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.RetentionDescriptor MaxCount(int value)
	{
		Instance.MaxCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum number of snapshots to retain, even if the snapshots have expired.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.RetentionDescriptor MinCount(int value)
	{
		Instance.MinCount = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Retention Build(System.Action<Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.RetentionDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.RetentionDescriptor(new Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Retention(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}