// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.WriteSummaryInfoConverter))]
public sealed partial class WriteSummaryInfo
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WriteSummaryInfo(int count, Elastic.Clients.Elasticsearch.Duration totalElapsed, System.TimeSpan totalElapsedNanos, Elastic.Clients.Elasticsearch.ByteSize totalSize, long totalSizeBytes, Elastic.Clients.Elasticsearch.Duration totalThrottled, long totalThrottledNanos)
	{
		Count = count;
		TotalElapsed = totalElapsed;
		TotalElapsedNanos = totalElapsedNanos;
		TotalSize = totalSize;
		TotalSizeBytes = totalSizeBytes;
		TotalThrottled = totalThrottled;
		TotalThrottledNanos = totalThrottledNanos;
	}
#if NET7_0_OR_GREATER
	public WriteSummaryInfo()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public WriteSummaryInfo()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal WriteSummaryInfo(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The number of write operations performed in the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Count { get; set; }

	/// <summary>
	/// <para>
	/// The total elapsed time spent on writing blobs in the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Duration TotalElapsed { get; set; }

	/// <summary>
	/// <para>
	/// The total elapsed time spent on writing blobs in the test, in nanoseconds.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan TotalElapsedNanos { get; set; }

	/// <summary>
	/// <para>
	/// The total size of all the blobs written in the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.ByteSize TotalSize { get; set; }

	/// <summary>
	/// <para>
	/// The total size of all the blobs written in the test, in bytes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long TotalSizeBytes { get; set; }

	/// <summary>
	/// <para>
	/// The total time spent waiting due to the <c>max_snapshot_bytes_per_sec</c> throttle.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Duration TotalThrottled { get; set; }

	/// <summary>
	/// <para>
	/// The total time spent waiting due to the <c>max_snapshot_bytes_per_sec</c> throttle, in nanoseconds.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long TotalThrottledNanos { get; set; }
}