// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot.Json;

public sealed partial class WriteSummaryInfoConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Snapshot.WriteSummaryInfo>
{
	private static readonly System.Text.Json.JsonEncodedText PropCount = System.Text.Json.JsonEncodedText.Encode("count");
	private static readonly System.Text.Json.JsonEncodedText PropTotalElapsed = System.Text.Json.JsonEncodedText.Encode("total_elapsed");
	private static readonly System.Text.Json.JsonEncodedText PropTotalElapsedNanos = System.Text.Json.JsonEncodedText.Encode("total_elapsed_nanos");
	private static readonly System.Text.Json.JsonEncodedText PropTotalSize = System.Text.Json.JsonEncodedText.Encode("total_size");
	private static readonly System.Text.Json.JsonEncodedText PropTotalSizeBytes = System.Text.Json.JsonEncodedText.Encode("total_size_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropTotalThrottled = System.Text.Json.JsonEncodedText.Encode("total_throttled");
	private static readonly System.Text.Json.JsonEncodedText PropTotalThrottledNanos = System.Text.Json.JsonEncodedText.Encode("total_throttled_nanos");

	public override Elastic.Clients.Elasticsearch.Snapshot.WriteSummaryInfo Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propCount = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration> propTotalElapsed = default;
		LocalJsonValue<System.TimeSpan> propTotalElapsedNanos = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize> propTotalSize = default;
		LocalJsonValue<long> propTotalSizeBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration> propTotalThrottled = default;
		LocalJsonValue<long> propTotalThrottledNanos = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propCount.TryReadProperty(ref reader, options, PropCount, null))
			{
				continue;
			}

			if (propTotalElapsed.TryReadProperty(ref reader, options, PropTotalElapsed, null))
			{
				continue;
			}

			if (propTotalElapsedNanos.TryReadProperty(ref reader, options, PropTotalElapsedNanos, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker))))
			{
				continue;
			}

			if (propTotalSize.TryReadProperty(ref reader, options, PropTotalSize, null))
			{
				continue;
			}

			if (propTotalSizeBytes.TryReadProperty(ref reader, options, PropTotalSizeBytes, null))
			{
				continue;
			}

			if (propTotalThrottled.TryReadProperty(ref reader, options, PropTotalThrottled, null))
			{
				continue;
			}

			if (propTotalThrottledNanos.TryReadProperty(ref reader, options, PropTotalThrottledNanos, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Snapshot.WriteSummaryInfo(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Count = propCount.Value,
			TotalElapsed = propTotalElapsed.Value,
			TotalElapsedNanos = propTotalElapsedNanos.Value,
			TotalSize = propTotalSize.Value,
			TotalSizeBytes = propTotalSizeBytes.Value,
			TotalThrottled = propTotalThrottled.Value,
			TotalThrottledNanos = propTotalThrottledNanos.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Snapshot.WriteSummaryInfo value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropCount, value.Count, null, null);
		writer.WriteProperty(options, PropTotalElapsed, value.TotalElapsed, null, null);
		writer.WriteProperty(options, PropTotalElapsedNanos, value.TotalElapsedNanos, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker)));
		writer.WriteProperty(options, PropTotalSize, value.TotalSize, null, null);
		writer.WriteProperty(options, PropTotalSizeBytes, value.TotalSizeBytes, null, null);
		writer.WriteProperty(options, PropTotalThrottled, value.TotalThrottled, null, null);
		writer.WriteProperty(options, PropTotalThrottledNanos, value.TotalThrottledNanos, null, null);
		writer.WriteEndObject();
	}
}