// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.StatusConverter))]
public sealed partial class Status
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public Status(bool includeGlobalState, System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Snapshot.SnapshotIndexStats> indices, string repository, Elastic.Clients.Elasticsearch.Snapshot.ShardsStats shardsStats, string snapshot, string state, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStats stats, string uuid)
	{
		IncludeGlobalState = includeGlobalState;
		Indices = indices;
		Repository = repository;
		ShardsStats = shardsStats;
		Snapshot = snapshot;
		State = state;
		Stats = stats;
		Uuid = uuid;
	}
#if NET7_0_OR_GREATER
	public Status()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public Status()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Status(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Indicates whether the current cluster state is included in the snapshot.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool IncludeGlobalState { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Snapshot.SnapshotIndexStats> Indices { get; set; }

	/// <summary>
	/// <para>
	/// The name of the repository that includes the snapshot.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Repository { get; set; }

	/// <summary>
	/// <para>
	/// Statistics for the shards in the snapshot.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Snapshot.ShardsStats ShardsStats { get; set; }

	/// <summary>
	/// <para>
	/// The name of the snapshot.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Snapshot { get; set; }

	/// <summary>
	/// <para>
	/// The current snapshot state:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>FAILED</c>: The snapshot finished with an error and failed to store any data.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>STARTED</c>: The snapshot is currently running.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>SUCCESS</c>: The snapshot completed.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string State { get; set; }

	/// <summary>
	/// <para>
	/// Details about the number (<c>file_count</c>) and size (<c>size_in_bytes</c>) of files included in the snapshot.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Snapshot.SnapshotStats Stats { get; set; }

	/// <summary>
	/// <para>
	/// The universally unique identifier (UUID) for the snapshot.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Uuid { get; set; }
}