// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.SnapshotStatsConverter))]
public sealed partial class SnapshotStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SnapshotStats(Elastic.Clients.Elasticsearch.Snapshot.FileCountSnapshotStats incremental, System.DateTimeOffset startTimeInMillis, System.TimeSpan timeInMillis, Elastic.Clients.Elasticsearch.Snapshot.FileCountSnapshotStats total)
	{
		Incremental = incremental;
		StartTimeInMillis = startTimeInMillis;
		TimeInMillis = timeInMillis;
		Total = total;
	}
#if NET7_0_OR_GREATER
	public SnapshotStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SnapshotStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SnapshotStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The number and size of files that still need to be copied as part of the incremental snapshot.
	/// For completed snapshots, this property indicates the number and size of files that were not already in the repository and were copied as part of the incremental snapshot.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Snapshot.FileCountSnapshotStats Incremental { get; set; }

	/// <summary>
	/// <para>
	/// The time, in milliseconds, when the snapshot creation process started.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset StartTimeInMillis { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? Time { get; set; }

	/// <summary>
	/// <para>
	/// The total time, in milliseconds, that it took for the snapshot process to complete.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan TimeInMillis { get; set; }

	/// <summary>
	/// <para>
	/// The total number and size of files that are referenced by the snapshot.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Snapshot.FileCountSnapshotStats Total { get; set; }
}