// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot.Json;

public sealed partial class SnapshotStateConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Snapshot.SnapshotState>
{
	private static readonly System.Text.Json.JsonEncodedText MemberFailed = System.Text.Json.JsonEncodedText.Encode("FAILED");
	private static readonly System.Text.Json.JsonEncodedText MemberInProgress = System.Text.Json.JsonEncodedText.Encode("IN_PROGRESS");
	private static readonly System.Text.Json.JsonEncodedText MemberIncompatible = System.Text.Json.JsonEncodedText.Encode("INCOMPATIBLE");
	private static readonly System.Text.Json.JsonEncodedText MemberPartial = System.Text.Json.JsonEncodedText.Encode("PARTIAL");
	private static readonly System.Text.Json.JsonEncodedText MemberSuccess = System.Text.Json.JsonEncodedText.Encode("SUCCESS");

	public override Elastic.Clients.Elasticsearch.Snapshot.SnapshotState Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberFailed))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotState.Failed;
		}

		if (reader.ValueTextEquals(MemberInProgress))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotState.InProgress;
		}

		if (reader.ValueTextEquals(MemberIncompatible))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotState.Incompatible;
		}

		if (reader.ValueTextEquals(MemberPartial))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotState.Partial;
		}

		if (reader.ValueTextEquals(MemberSuccess))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotState.Success;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberFailed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotState.Failed;
		}

		if (string.Equals(value, MemberInProgress.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotState.InProgress;
		}

		if (string.Equals(value, MemberIncompatible.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotState.Incompatible;
		}

		if (string.Equals(value, MemberPartial.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotState.Partial;
		}

		if (string.Equals(value, MemberSuccess.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotState.Success;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Snapshot.SnapshotState)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Snapshot.SnapshotState value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Snapshot.SnapshotState.Failed:
				writer.WriteStringValue(MemberFailed);
				break;
			case Elastic.Clients.Elasticsearch.Snapshot.SnapshotState.InProgress:
				writer.WriteStringValue(MemberInProgress);
				break;
			case Elastic.Clients.Elasticsearch.Snapshot.SnapshotState.Incompatible:
				writer.WriteStringValue(MemberIncompatible);
				break;
			case Elastic.Clients.Elasticsearch.Snapshot.SnapshotState.Partial:
				writer.WriteStringValue(MemberPartial);
				break;
			case Elastic.Clients.Elasticsearch.Snapshot.SnapshotState.Success:
				writer.WriteStringValue(MemberSuccess);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Snapshot.SnapshotState)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Snapshot.SnapshotState ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Snapshot.SnapshotState value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}