// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot.Json;

public sealed partial class SnapshotSortConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDuration = System.Text.Json.JsonEncodedText.Encode("duration");
	private static readonly System.Text.Json.JsonEncodedText MemberFailedShardCount = System.Text.Json.JsonEncodedText.Encode("failed_shard_count");
	private static readonly System.Text.Json.JsonEncodedText MemberIndexCount = System.Text.Json.JsonEncodedText.Encode("index_count");
	private static readonly System.Text.Json.JsonEncodedText MemberName = System.Text.Json.JsonEncodedText.Encode("name");
	private static readonly System.Text.Json.JsonEncodedText MemberRepository = System.Text.Json.JsonEncodedText.Encode("repository");
	private static readonly System.Text.Json.JsonEncodedText MemberShardCount = System.Text.Json.JsonEncodedText.Encode("shard_count");
	private static readonly System.Text.Json.JsonEncodedText MemberStartTime = System.Text.Json.JsonEncodedText.Encode("start_time");

	public override Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDuration))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.Duration;
		}

		if (reader.ValueTextEquals(MemberFailedShardCount))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.FailedShardCount;
		}

		if (reader.ValueTextEquals(MemberIndexCount))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.IndexCount;
		}

		if (reader.ValueTextEquals(MemberName))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.Name;
		}

		if (reader.ValueTextEquals(MemberRepository))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.Repository;
		}

		if (reader.ValueTextEquals(MemberShardCount))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.ShardCount;
		}

		if (reader.ValueTextEquals(MemberStartTime))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.StartTime;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDuration.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.Duration;
		}

		if (string.Equals(value, MemberFailedShardCount.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.FailedShardCount;
		}

		if (string.Equals(value, MemberIndexCount.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.IndexCount;
		}

		if (string.Equals(value, MemberName.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.Name;
		}

		if (string.Equals(value, MemberRepository.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.Repository;
		}

		if (string.Equals(value, MemberShardCount.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.ShardCount;
		}

		if (string.Equals(value, MemberStartTime.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.StartTime;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.Duration:
				writer.WriteStringValue(MemberDuration);
				break;
			case Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.FailedShardCount:
				writer.WriteStringValue(MemberFailedShardCount);
				break;
			case Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.IndexCount:
				writer.WriteStringValue(MemberIndexCount);
				break;
			case Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.Name:
				writer.WriteStringValue(MemberName);
				break;
			case Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.Repository:
				writer.WriteStringValue(MemberRepository);
				break;
			case Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.ShardCount:
				writer.WriteStringValue(MemberShardCount);
				break;
			case Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort.StartTime:
				writer.WriteStringValue(MemberStartTime);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Snapshot.SnapshotSort value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}