// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.SnapshotInfoConverter))]
public sealed partial class SnapshotInfo
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SnapshotInfo(System.Collections.Generic.IReadOnlyCollection<string> dataStreams, string snapshot, string uuid)
	{
		DataStreams = dataStreams;
		Snapshot = snapshot;
		Uuid = uuid;
	}
#if NET7_0_OR_GREATER
	public SnapshotInfo()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SnapshotInfo()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SnapshotInfo(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<string> DataStreams { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? Duration { get; set; }
	public System.TimeSpan? DurationInMillis { get; set; }
	public System.DateTimeOffset? EndTime { get; set; }
	public System.DateTimeOffset? EndTimeInMillis { get; set; }
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Snapshot.SnapshotShardFailure>? Failures { get; set; }
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Snapshot.InfoFeatureState>? FeatureStates { get; set; }
	public bool? IncludeGlobalState { get; set; }
	public System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Snapshot.IndexDetails>? IndexDetails { get; set; }
	public System.Collections.Generic.IReadOnlyCollection<string>? Indices { get; set; }
	public System.Collections.Generic.IReadOnlyDictionary<string, object>? Metadata { get; set; }
	public string? Reason { get; set; }
	public string? Repository { get; set; }
	public Elastic.Clients.Elasticsearch.ShardStatistics? Shards { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Snapshot { get; set; }
	public System.DateTimeOffset? StartTime { get; set; }
	public System.DateTimeOffset? StartTimeInMillis { get; set; }
	public string? State { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Uuid { get; set; }
	public string? Version { get; set; }
	public long? VersionId { get; set; }
}