// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.SharedFileSystemRepositorySettingsConverter))]
public sealed partial class SharedFileSystemRepositorySettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SharedFileSystemRepositorySettings(string location)
	{
		Location = location;
	}
#if NET7_0_OR_GREATER
	public SharedFileSystemRepositorySettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SharedFileSystemRepositorySettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SharedFileSystemRepositorySettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Big files can be broken down into multiple smaller blobs in the blob store during snapshotting.
	/// It is not recommended to change this value from its default unless there is an explicit reason for limiting the size of blobs in the repository.
	/// Setting a value lower than the default can result in an increased number of API calls to the blob store during snapshot create and restore operations compared to using the default value and thus make both operations slower and more costly.
	/// Specify the chunk size as a byte unit, for example: <c>10MB</c>, <c>5KB</c>, 500B.
	/// The default varies by repository type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? ChunkSize { get; set; }

	/// <summary>
	/// <para>
	/// When set to <c>true</c>, metadata files are stored in compressed format.
	/// This setting doesn't affect index files that are already compressed by default.
	/// </para>
	/// </summary>
	public bool? Compress { get; set; }

	/// <summary>
	/// <para>
	/// The location of the shared filesystem used to store and retrieve snapshots.
	/// This location must be registered in the <c>path.repo</c> setting on all master and data nodes in the cluster.
	/// Unlike <c>path.repo</c>, this setting supports only a single file path.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Location { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of snapshots the repository can contain.
	/// The default is <c>Integer.MAX_VALUE</c>, which is 2^31-1 or <c>2147483647</c>.
	/// </para>
	/// </summary>
	public int? MaxNumberOfSnapshots { get; set; }

	/// <summary>
	/// <para>
	/// The maximum snapshot restore rate per node.
	/// It defaults to unlimited.
	/// Note that restores are also throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxRestoreBytesPerSec { get; set; }

	/// <summary>
	/// <para>
	/// The maximum snapshot creation rate per node.
	/// It defaults to 40mb per second.
	/// Note that if the recovery settings for managed services are set, then it defaults to unlimited, and the rate is additionally throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxSnapshotBytesPerSec { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the repository is read-only.
	/// The cluster can retrieve and restore snapshots from the repository but not write to the repository or create snapshots in it.
	/// </para>
	/// <para>
	/// Only a cluster with write access can create snapshots in the repository.
	/// All other clusters connected to the repository should have the <c>readonly</c> parameter set to <c>true</c>.
	/// </para>
	/// <para>
	/// If <c>false</c>, the cluster can write to the repository and create snapshots in it.
	/// </para>
	/// <para>
	/// IMPORTANT: If you register the same snapshot repository with multiple clusters, only one cluster should have write access to the repository.
	/// Having multiple clusters write to the repository at the same time risks corrupting the contents of the repository.
	/// </para>
	/// </summary>
	public bool? Readonly { get; set; }
}

public readonly partial struct SharedFileSystemRepositorySettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SharedFileSystemRepositorySettingsDescriptor(Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SharedFileSystemRepositorySettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor(Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettings instance) => new Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettings(Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Big files can be broken down into multiple smaller blobs in the blob store during snapshotting.
	/// It is not recommended to change this value from its default unless there is an explicit reason for limiting the size of blobs in the repository.
	/// Setting a value lower than the default can result in an increased number of API calls to the blob store during snapshot create and restore operations compared to using the default value and thus make both operations slower and more costly.
	/// Specify the chunk size as a byte unit, for example: <c>10MB</c>, <c>5KB</c>, 500B.
	/// The default varies by repository type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor ChunkSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.ChunkSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Big files can be broken down into multiple smaller blobs in the blob store during snapshotting.
	/// It is not recommended to change this value from its default unless there is an explicit reason for limiting the size of blobs in the repository.
	/// Setting a value lower than the default can result in an increased number of API calls to the blob store during snapshot create and restore operations compared to using the default value and thus make both operations slower and more costly.
	/// Specify the chunk size as a byte unit, for example: <c>10MB</c>, <c>5KB</c>, 500B.
	/// The default varies by repository type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor ChunkSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.ChunkSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// When set to <c>true</c>, metadata files are stored in compressed format.
	/// This setting doesn't affect index files that are already compressed by default.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor Compress(bool? value = true)
	{
		Instance.Compress = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The location of the shared filesystem used to store and retrieve snapshots.
	/// This location must be registered in the <c>path.repo</c> setting on all master and data nodes in the cluster.
	/// Unlike <c>path.repo</c>, this setting supports only a single file path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor Location(string value)
	{
		Instance.Location = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of snapshots the repository can contain.
	/// The default is <c>Integer.MAX_VALUE</c>, which is 2^31-1 or <c>2147483647</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor MaxNumberOfSnapshots(int? value)
	{
		Instance.MaxNumberOfSnapshots = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum snapshot restore rate per node.
	/// It defaults to unlimited.
	/// Note that restores are also throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor MaxRestoreBytesPerSec(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxRestoreBytesPerSec = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum snapshot restore rate per node.
	/// It defaults to unlimited.
	/// Note that restores are also throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor MaxRestoreBytesPerSec(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxRestoreBytesPerSec = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum snapshot creation rate per node.
	/// It defaults to 40mb per second.
	/// Note that if the recovery settings for managed services are set, then it defaults to unlimited, and the rate is additionally throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor MaxSnapshotBytesPerSec(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxSnapshotBytesPerSec = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum snapshot creation rate per node.
	/// It defaults to 40mb per second.
	/// Note that if the recovery settings for managed services are set, then it defaults to unlimited, and the rate is additionally throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor MaxSnapshotBytesPerSec(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxSnapshotBytesPerSec = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the repository is read-only.
	/// The cluster can retrieve and restore snapshots from the repository but not write to the repository or create snapshots in it.
	/// </para>
	/// <para>
	/// Only a cluster with write access can create snapshots in the repository.
	/// All other clusters connected to the repository should have the <c>readonly</c> parameter set to <c>true</c>.
	/// </para>
	/// <para>
	/// If <c>false</c>, the cluster can write to the repository and create snapshots in it.
	/// </para>
	/// <para>
	/// IMPORTANT: If you register the same snapshot repository with multiple clusters, only one cluster should have write access to the repository.
	/// Having multiple clusters write to the repository at the same time risks corrupting the contents of the repository.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor Readonly(bool? value = true)
	{
		Instance.Readonly = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettings Build(System.Action<Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor(new Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}