// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.SharedFileSystemRepositoryConverter))]
public sealed partial class SharedFileSystemRepository : Elastic.Clients.Elasticsearch.Snapshot.IRepository
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SharedFileSystemRepository(Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettings settings)
	{
		Settings = settings;
	}
#if NET7_0_OR_GREATER
	public SharedFileSystemRepository()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SharedFileSystemRepository()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SharedFileSystemRepository(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The repository settings.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettings Settings { get; set; }

	/// <summary>
	/// <para>
	/// The shared file system repository type.
	/// </para>
	/// </summary>
	public string Type => "fs";

	public string? Uuid { get; set; }
}

public readonly partial struct SharedFileSystemRepositoryDescriptor
{
	internal Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepository Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SharedFileSystemRepositoryDescriptor(Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepository instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SharedFileSystemRepositoryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepository(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositoryDescriptor(Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepository instance) => new Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositoryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepository(Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositoryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The repository settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositoryDescriptor Settings(Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettings value)
	{
		Instance.Settings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The repository settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositoryDescriptor Settings(System.Action<Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor> action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositorySettingsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositoryDescriptor Uuid(string? value)
	{
		Instance.Uuid = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepository Build(System.Action<Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositoryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositoryDescriptor(new Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepository(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}