// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.ShardsStatsStageConverter))]
public enum ShardsStatsStage
{
	/// <summary>
	/// <para>
	/// The number of shards in the snapshot that were successfully stored in the repository.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "DONE")]
	Done,
	/// <summary>
	/// <para>
	/// The number of shards in the snapshot that were not successfully stored in the repository.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "FAILURE")]
	Failure,
	/// <summary>
	/// <para>
	/// The number of shards in the snapshot that are in the finalizing stage of being stored in the repository.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "FINALIZE")]
	Finalize,
	/// <summary>
	/// <para>
	/// The number of shards in the snapshot that are in the initializing stage of being stored in the repository.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "INIT")]
	Init,
	/// <summary>
	/// <para>
	/// The number of shards in the snapshot that are in the started stage of being stored in the repository.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "STARTED")]
	Started
}