// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot.Json;

public sealed partial class ShardsStatsStageConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDone = System.Text.Json.JsonEncodedText.Encode("DONE");
	private static readonly System.Text.Json.JsonEncodedText MemberFailure = System.Text.Json.JsonEncodedText.Encode("FAILURE");
	private static readonly System.Text.Json.JsonEncodedText MemberFinalize = System.Text.Json.JsonEncodedText.Encode("FINALIZE");
	private static readonly System.Text.Json.JsonEncodedText MemberInit = System.Text.Json.JsonEncodedText.Encode("INIT");
	private static readonly System.Text.Json.JsonEncodedText MemberStarted = System.Text.Json.JsonEncodedText.Encode("STARTED");

	public override Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDone))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage.Done;
		}

		if (reader.ValueTextEquals(MemberFailure))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage.Failure;
		}

		if (reader.ValueTextEquals(MemberFinalize))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage.Finalize;
		}

		if (reader.ValueTextEquals(MemberInit))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage.Init;
		}

		if (reader.ValueTextEquals(MemberStarted))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage.Started;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDone.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage.Done;
		}

		if (string.Equals(value, MemberFailure.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage.Failure;
		}

		if (string.Equals(value, MemberFinalize.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage.Finalize;
		}

		if (string.Equals(value, MemberInit.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage.Init;
		}

		if (string.Equals(value, MemberStarted.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage.Started;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage.Done:
				writer.WriteStringValue(MemberDone);
				break;
			case Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage.Failure:
				writer.WriteStringValue(MemberFailure);
				break;
			case Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage.Finalize:
				writer.WriteStringValue(MemberFinalize);
				break;
			case Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage.Init:
				writer.WriteStringValue(MemberInit);
				break;
			case Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage.Started:
				writer.WriteStringValue(MemberStarted);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Snapshot.ShardsStatsStage value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}