// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot.Json;

public sealed partial class ShardsStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Snapshot.ShardsStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropDone = System.Text.Json.JsonEncodedText.Encode("done");
	private static readonly System.Text.Json.JsonEncodedText PropFailed = System.Text.Json.JsonEncodedText.Encode("failed");
	private static readonly System.Text.Json.JsonEncodedText PropFinalizing = System.Text.Json.JsonEncodedText.Encode("finalizing");
	private static readonly System.Text.Json.JsonEncodedText PropInitializing = System.Text.Json.JsonEncodedText.Encode("initializing");
	private static readonly System.Text.Json.JsonEncodedText PropStarted = System.Text.Json.JsonEncodedText.Encode("started");
	private static readonly System.Text.Json.JsonEncodedText PropTotal = System.Text.Json.JsonEncodedText.Encode("total");

	public override Elastic.Clients.Elasticsearch.Snapshot.ShardsStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<long> propDone = default;
		LocalJsonValue<long> propFailed = default;
		LocalJsonValue<long> propFinalizing = default;
		LocalJsonValue<long> propInitializing = default;
		LocalJsonValue<long> propStarted = default;
		LocalJsonValue<long> propTotal = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propDone.TryReadProperty(ref reader, options, PropDone, null))
			{
				continue;
			}

			if (propFailed.TryReadProperty(ref reader, options, PropFailed, null))
			{
				continue;
			}

			if (propFinalizing.TryReadProperty(ref reader, options, PropFinalizing, null))
			{
				continue;
			}

			if (propInitializing.TryReadProperty(ref reader, options, PropInitializing, null))
			{
				continue;
			}

			if (propStarted.TryReadProperty(ref reader, options, PropStarted, null))
			{
				continue;
			}

			if (propTotal.TryReadProperty(ref reader, options, PropTotal, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Snapshot.ShardsStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Done = propDone.Value,
			Failed = propFailed.Value,
			Finalizing = propFinalizing.Value,
			Initializing = propInitializing.Value,
			Started = propStarted.Value,
			Total = propTotal.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Snapshot.ShardsStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropDone, value.Done, null, null);
		writer.WriteProperty(options, PropFailed, value.Failed, null, null);
		writer.WriteProperty(options, PropFinalizing, value.Finalizing, null, null);
		writer.WriteProperty(options, PropInitializing, value.Initializing, null, null);
		writer.WriteProperty(options, PropStarted, value.Started, null, null);
		writer.WriteProperty(options, PropTotal, value.Total, null, null);
		writer.WriteEndObject();
	}
}