// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.S3RepositorySettingsConverter))]
public sealed partial class S3RepositorySettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public S3RepositorySettings(string bucket)
	{
		Bucket = bucket;
	}
#if NET7_0_OR_GREATER
	public S3RepositorySettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public S3RepositorySettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal S3RepositorySettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The path to the repository data within its bucket.
	/// It defaults to an empty string, meaning that the repository is at the root of the bucket.
	/// The value of this setting should not start or end with a forward slash (<c>/</c>).
	/// </para>
	/// <para>
	/// NOTE: Don't set base_path when configuring a snapshot repository for Elastic Cloud Enterprise.
	/// Elastic Cloud Enterprise automatically generates the <c>base_path</c> for each deployment so that multiple deployments may share the same bucket.
	/// </para>
	/// </summary>
	public string? BasePath { get; set; }

	/// <summary>
	/// <para>
	/// The name of the S3 bucket to use for snapshots.
	/// The bucket name must adhere to Amazon's S3 bucket naming rules.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Bucket { get; set; }

	/// <summary>
	/// <para>
	/// The minimum threshold below which the chunk is uploaded using a single request.
	/// Beyond this threshold, the S3 repository will use the AWS Multipart Upload API to split the chunk into several parts, each of <c>buffer_size</c> length, and to upload each part in its own request.
	/// Note that setting a buffer size lower than 5mb is not allowed since it will prevent the use of the Multipart API and may result in upload errors.
	/// It is also not possible to set a buffer size greater than 5gb as it is the maximum upload size allowed by S3.
	/// Defaults to <c>100mb</c> or 5% of JVM heap, whichever is smaller.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? BufferSize { get; set; }

	/// <summary>
	/// <para>
	/// The S3 repository supports all S3 canned ACLs: <c>private</c>, <c>public-read</c>, <c>public-read-write</c>, <c>authenticated-read</c>, <c>log-delivery-write</c>, <c>bucket-owner-read</c>, <c>bucket-owner-full-control</c>.
	/// You could specify a canned ACL using the <c>canned_acl</c> setting.
	/// When the S3 repository creates buckets and objects, it adds the canned ACL into the buckets and objects.
	/// </para>
	/// </summary>
	public string? CannedAcl { get; set; }

	/// <summary>
	/// <para>
	/// Big files can be broken down into multiple smaller blobs in the blob store during snapshotting.
	/// It is not recommended to change this value from its default unless there is an explicit reason for limiting the size of blobs in the repository.
	/// Setting a value lower than the default can result in an increased number of API calls to the blob store during snapshot create and restore operations compared to using the default value and thus make both operations slower and more costly.
	/// Specify the chunk size as a byte unit, for example: <c>10MB</c>, <c>5KB</c>, 500B.
	/// The default varies by repository type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? ChunkSize { get; set; }

	/// <summary>
	/// <para>
	/// The name of the S3 client to use to connect to S3.
	/// </para>
	/// </summary>
	public string? Client { get; set; }

	/// <summary>
	/// <para>
	/// When set to <c>true</c>, metadata files are stored in compressed format.
	/// This setting doesn't affect index files that are already compressed by default.
	/// </para>
	/// </summary>
	public bool? Compress { get; set; }

	/// <summary>
	/// <para>
	/// The maxmimum batch size, between 1 and 1000, used for <c>DeleteObjects</c> requests.
	/// Defaults to 1000 which is the maximum number supported by the  AWS DeleteObjects API.
	/// </para>
	/// </summary>
	public int? DeleteObjectsMaxSize { get; set; }

	/// <summary>
	/// <para>
	/// The time to wait before trying again if an attempt to read a linearizable register fails.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? GetRegisterRetryDelay { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of parts that Elasticsearch will write during a multipart upload of a single object.
	/// Files which are larger than <c>buffer_size × max_multipart_parts</c> will be chunked into several smaller objects.
	/// Elasticsearch may also split a file across multiple objects to satisfy other constraints such as the <c>chunk_size</c> limit.
	/// Defaults to <c>10000</c> which is the maximum number of parts in a multipart upload in AWS S3.
	/// </para>
	/// </summary>
	public int? MaxMultipartParts { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of possibly-dangling multipart uploads to clean up in each batch of snapshot deletions.
	/// Defaults to 1000 which is the maximum number supported by the AWS ListMultipartUploads API.
	/// If set to <c>0</c>, Elasticsearch will not attempt to clean up dangling multipart uploads.
	/// </para>
	/// </summary>
	public int? MaxMultipartUploadCleanupSize { get; set; }

	/// <summary>
	/// <para>
	/// The maximum snapshot restore rate per node.
	/// It defaults to unlimited.
	/// Note that restores are also throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxRestoreBytesPerSec { get; set; }

	/// <summary>
	/// <para>
	/// The maximum snapshot creation rate per node.
	/// It defaults to 40mb per second.
	/// Note that if the recovery settings for managed services are set, then it defaults to unlimited, and the rate is additionally throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxSnapshotBytesPerSec { get; set; }

	/// <summary>
	/// <para>
	/// If true, the repository is read-only.
	/// The cluster can retrieve and restore snapshots from the repository but not write to the repository or create snapshots in it.
	/// </para>
	/// <para>
	/// Only a cluster with write access can create snapshots in the repository.
	/// All other clusters connected to the repository should have the <c>readonly</c> parameter set to <c>true</c>.
	/// </para>
	/// <para>
	/// If <c>false</c>, the cluster can write to the repository and create snapshots in it.
	/// </para>
	/// <para>
	/// IMPORTANT: If you register the same snapshot repository with multiple clusters, only one cluster should have write access to the repository.
	/// Having multiple clusters write to the repository at the same time risks corrupting the contents of the repository.
	/// </para>
	/// </summary>
	public bool? Readonly { get; set; }

	/// <summary>
	/// <para>
	/// When set to <c>true</c>, files are encrypted on server side using an AES256 algorithm.
	/// </para>
	/// </summary>
	public bool? ServerSideEncryption { get; set; }

	/// <summary>
	/// <para>
	/// The S3 storage class for objects written to the repository.
	/// Values may be <c>standard</c>, <c>reduced_redundancy</c>, <c>standard_ia</c>, <c>onezone_ia</c>, and <c>intelligent_tiering</c>.
	/// </para>
	/// </summary>
	public string? StorageClass { get; set; }

	/// <summary>
	/// <para>
	/// The delay before the first retry and the amount the delay is incremented by on each subsequent retry.
	/// The default is 50ms and the minimum is 0ms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? ThrottledDeleteRetryDelayIncrement { get; set; }

	/// <summary>
	/// <para>
	/// The upper bound on how long the delays between retries will grow to.
	/// The default is 5s and the minimum is 0ms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? ThrottledDeleteRetryMaximumDelay { get; set; }

	/// <summary>
	/// <para>
	/// The number times to retry a throttled snapshot deletion.
	/// The default is 10 and the minimum value is 0 which will disable retries altogether.
	/// Note that if retries are enabled in the Azure client, each of these retries comprises that many client-level retries.
	/// </para>
	/// </summary>
	public int? ThrottledDeleteRetryMaximumNumberOfRetries { get; set; }
}

public readonly partial struct S3RepositorySettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public S3RepositorySettingsDescriptor(Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public S3RepositorySettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor(Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettings instance) => new Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettings(Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The path to the repository data within its bucket.
	/// It defaults to an empty string, meaning that the repository is at the root of the bucket.
	/// The value of this setting should not start or end with a forward slash (<c>/</c>).
	/// </para>
	/// <para>
	/// NOTE: Don't set base_path when configuring a snapshot repository for Elastic Cloud Enterprise.
	/// Elastic Cloud Enterprise automatically generates the <c>base_path</c> for each deployment so that multiple deployments may share the same bucket.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor BasePath(string? value)
	{
		Instance.BasePath = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the S3 bucket to use for snapshots.
	/// The bucket name must adhere to Amazon's S3 bucket naming rules.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor Bucket(string value)
	{
		Instance.Bucket = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum threshold below which the chunk is uploaded using a single request.
	/// Beyond this threshold, the S3 repository will use the AWS Multipart Upload API to split the chunk into several parts, each of <c>buffer_size</c> length, and to upload each part in its own request.
	/// Note that setting a buffer size lower than 5mb is not allowed since it will prevent the use of the Multipart API and may result in upload errors.
	/// It is also not possible to set a buffer size greater than 5gb as it is the maximum upload size allowed by S3.
	/// Defaults to <c>100mb</c> or 5% of JVM heap, whichever is smaller.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor BufferSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.BufferSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum threshold below which the chunk is uploaded using a single request.
	/// Beyond this threshold, the S3 repository will use the AWS Multipart Upload API to split the chunk into several parts, each of <c>buffer_size</c> length, and to upload each part in its own request.
	/// Note that setting a buffer size lower than 5mb is not allowed since it will prevent the use of the Multipart API and may result in upload errors.
	/// It is also not possible to set a buffer size greater than 5gb as it is the maximum upload size allowed by S3.
	/// Defaults to <c>100mb</c> or 5% of JVM heap, whichever is smaller.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor BufferSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.BufferSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The S3 repository supports all S3 canned ACLs: <c>private</c>, <c>public-read</c>, <c>public-read-write</c>, <c>authenticated-read</c>, <c>log-delivery-write</c>, <c>bucket-owner-read</c>, <c>bucket-owner-full-control</c>.
	/// You could specify a canned ACL using the <c>canned_acl</c> setting.
	/// When the S3 repository creates buckets and objects, it adds the canned ACL into the buckets and objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor CannedAcl(string? value)
	{
		Instance.CannedAcl = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Big files can be broken down into multiple smaller blobs in the blob store during snapshotting.
	/// It is not recommended to change this value from its default unless there is an explicit reason for limiting the size of blobs in the repository.
	/// Setting a value lower than the default can result in an increased number of API calls to the blob store during snapshot create and restore operations compared to using the default value and thus make both operations slower and more costly.
	/// Specify the chunk size as a byte unit, for example: <c>10MB</c>, <c>5KB</c>, 500B.
	/// The default varies by repository type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor ChunkSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.ChunkSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Big files can be broken down into multiple smaller blobs in the blob store during snapshotting.
	/// It is not recommended to change this value from its default unless there is an explicit reason for limiting the size of blobs in the repository.
	/// Setting a value lower than the default can result in an increased number of API calls to the blob store during snapshot create and restore operations compared to using the default value and thus make both operations slower and more costly.
	/// Specify the chunk size as a byte unit, for example: <c>10MB</c>, <c>5KB</c>, 500B.
	/// The default varies by repository type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor ChunkSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.ChunkSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the S3 client to use to connect to S3.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor Client(string? value)
	{
		Instance.Client = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// When set to <c>true</c>, metadata files are stored in compressed format.
	/// This setting doesn't affect index files that are already compressed by default.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor Compress(bool? value = true)
	{
		Instance.Compress = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maxmimum batch size, between 1 and 1000, used for <c>DeleteObjects</c> requests.
	/// Defaults to 1000 which is the maximum number supported by the  AWS DeleteObjects API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor DeleteObjectsMaxSize(int? value)
	{
		Instance.DeleteObjectsMaxSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The time to wait before trying again if an attempt to read a linearizable register fails.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor GetRegisterRetryDelay(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.GetRegisterRetryDelay = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of parts that Elasticsearch will write during a multipart upload of a single object.
	/// Files which are larger than <c>buffer_size × max_multipart_parts</c> will be chunked into several smaller objects.
	/// Elasticsearch may also split a file across multiple objects to satisfy other constraints such as the <c>chunk_size</c> limit.
	/// Defaults to <c>10000</c> which is the maximum number of parts in a multipart upload in AWS S3.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor MaxMultipartParts(int? value)
	{
		Instance.MaxMultipartParts = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of possibly-dangling multipart uploads to clean up in each batch of snapshot deletions.
	/// Defaults to 1000 which is the maximum number supported by the AWS ListMultipartUploads API.
	/// If set to <c>0</c>, Elasticsearch will not attempt to clean up dangling multipart uploads.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor MaxMultipartUploadCleanupSize(int? value)
	{
		Instance.MaxMultipartUploadCleanupSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum snapshot restore rate per node.
	/// It defaults to unlimited.
	/// Note that restores are also throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor MaxRestoreBytesPerSec(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxRestoreBytesPerSec = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum snapshot restore rate per node.
	/// It defaults to unlimited.
	/// Note that restores are also throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor MaxRestoreBytesPerSec(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxRestoreBytesPerSec = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum snapshot creation rate per node.
	/// It defaults to 40mb per second.
	/// Note that if the recovery settings for managed services are set, then it defaults to unlimited, and the rate is additionally throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor MaxSnapshotBytesPerSec(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxSnapshotBytesPerSec = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum snapshot creation rate per node.
	/// It defaults to 40mb per second.
	/// Note that if the recovery settings for managed services are set, then it defaults to unlimited, and the rate is additionally throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor MaxSnapshotBytesPerSec(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxSnapshotBytesPerSec = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, the repository is read-only.
	/// The cluster can retrieve and restore snapshots from the repository but not write to the repository or create snapshots in it.
	/// </para>
	/// <para>
	/// Only a cluster with write access can create snapshots in the repository.
	/// All other clusters connected to the repository should have the <c>readonly</c> parameter set to <c>true</c>.
	/// </para>
	/// <para>
	/// If <c>false</c>, the cluster can write to the repository and create snapshots in it.
	/// </para>
	/// <para>
	/// IMPORTANT: If you register the same snapshot repository with multiple clusters, only one cluster should have write access to the repository.
	/// Having multiple clusters write to the repository at the same time risks corrupting the contents of the repository.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor Readonly(bool? value = true)
	{
		Instance.Readonly = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// When set to <c>true</c>, files are encrypted on server side using an AES256 algorithm.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor ServerSideEncryption(bool? value = true)
	{
		Instance.ServerSideEncryption = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The S3 storage class for objects written to the repository.
	/// Values may be <c>standard</c>, <c>reduced_redundancy</c>, <c>standard_ia</c>, <c>onezone_ia</c>, and <c>intelligent_tiering</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor StorageClass(string? value)
	{
		Instance.StorageClass = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The delay before the first retry and the amount the delay is incremented by on each subsequent retry.
	/// The default is 50ms and the minimum is 0ms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor ThrottledDeleteRetryDelayIncrement(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.ThrottledDeleteRetryDelayIncrement = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The upper bound on how long the delays between retries will grow to.
	/// The default is 5s and the minimum is 0ms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor ThrottledDeleteRetryMaximumDelay(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.ThrottledDeleteRetryMaximumDelay = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number times to retry a throttled snapshot deletion.
	/// The default is 10 and the minimum value is 0 which will disable retries altogether.
	/// Note that if retries are enabled in the Azure client, each of these retries comprises that many client-level retries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor ThrottledDeleteRetryMaximumNumberOfRetries(int? value)
	{
		Instance.ThrottledDeleteRetryMaximumNumberOfRetries = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettings Build(System.Action<Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettingsDescriptor(new Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}