// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot.Json;

public sealed partial class S3RepositorySettingsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettings>
{
	private static readonly System.Text.Json.JsonEncodedText PropBasePath = System.Text.Json.JsonEncodedText.Encode("base_path");
	private static readonly System.Text.Json.JsonEncodedText PropBucket = System.Text.Json.JsonEncodedText.Encode("bucket");
	private static readonly System.Text.Json.JsonEncodedText PropBufferSize = System.Text.Json.JsonEncodedText.Encode("buffer_size");
	private static readonly System.Text.Json.JsonEncodedText PropCannedAcl = System.Text.Json.JsonEncodedText.Encode("canned_acl");
	private static readonly System.Text.Json.JsonEncodedText PropChunkSize = System.Text.Json.JsonEncodedText.Encode("chunk_size");
	private static readonly System.Text.Json.JsonEncodedText PropClient = System.Text.Json.JsonEncodedText.Encode("client");
	private static readonly System.Text.Json.JsonEncodedText PropCompress = System.Text.Json.JsonEncodedText.Encode("compress");
	private static readonly System.Text.Json.JsonEncodedText PropDeleteObjectsMaxSize = System.Text.Json.JsonEncodedText.Encode("delete_objects_max_size");
	private static readonly System.Text.Json.JsonEncodedText PropGetRegisterRetryDelay = System.Text.Json.JsonEncodedText.Encode("get_register_retry_delay");
	private static readonly System.Text.Json.JsonEncodedText PropMaxMultipartParts = System.Text.Json.JsonEncodedText.Encode("max_multipart_parts");
	private static readonly System.Text.Json.JsonEncodedText PropMaxMultipartUploadCleanupSize = System.Text.Json.JsonEncodedText.Encode("max_multipart_upload_cleanup_size");
	private static readonly System.Text.Json.JsonEncodedText PropMaxRestoreBytesPerSec = System.Text.Json.JsonEncodedText.Encode("max_restore_bytes_per_sec");
	private static readonly System.Text.Json.JsonEncodedText PropMaxSnapshotBytesPerSec = System.Text.Json.JsonEncodedText.Encode("max_snapshot_bytes_per_sec");
	private static readonly System.Text.Json.JsonEncodedText PropReadonly = System.Text.Json.JsonEncodedText.Encode("readonly");
	private static readonly System.Text.Json.JsonEncodedText PropServerSideEncryption = System.Text.Json.JsonEncodedText.Encode("server_side_encryption");
	private static readonly System.Text.Json.JsonEncodedText PropStorageClass = System.Text.Json.JsonEncodedText.Encode("storage_class");
	private static readonly System.Text.Json.JsonEncodedText PropThrottledDeleteRetryDelayIncrement = System.Text.Json.JsonEncodedText.Encode("throttled_delete_retry.delay_increment");
	private static readonly System.Text.Json.JsonEncodedText PropThrottledDeleteRetryMaximumDelay = System.Text.Json.JsonEncodedText.Encode("throttled_delete_retry.maximum_delay");
	private static readonly System.Text.Json.JsonEncodedText PropThrottledDeleteRetryMaximumNumberOfRetries = System.Text.Json.JsonEncodedText.Encode("throttled_delete_retry.maximum_number_of_retries");

	public override Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettings Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propBasePath = default;
		LocalJsonValue<string> propBucket = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propBufferSize = default;
		LocalJsonValue<string?> propCannedAcl = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propChunkSize = default;
		LocalJsonValue<string?> propClient = default;
		LocalJsonValue<bool?> propCompress = default;
		LocalJsonValue<int?> propDeleteObjectsMaxSize = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propGetRegisterRetryDelay = default;
		LocalJsonValue<int?> propMaxMultipartParts = default;
		LocalJsonValue<int?> propMaxMultipartUploadCleanupSize = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propMaxRestoreBytesPerSec = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propMaxSnapshotBytesPerSec = default;
		LocalJsonValue<bool?> propReadonly = default;
		LocalJsonValue<bool?> propServerSideEncryption = default;
		LocalJsonValue<string?> propStorageClass = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propThrottledDeleteRetryDelayIncrement = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propThrottledDeleteRetryMaximumDelay = default;
		LocalJsonValue<int?> propThrottledDeleteRetryMaximumNumberOfRetries = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propBasePath.TryReadProperty(ref reader, options, PropBasePath, null))
			{
				continue;
			}

			if (propBucket.TryReadProperty(ref reader, options, PropBucket, null))
			{
				continue;
			}

			if (propBufferSize.TryReadProperty(ref reader, options, PropBufferSize, null))
			{
				continue;
			}

			if (propCannedAcl.TryReadProperty(ref reader, options, PropCannedAcl, null))
			{
				continue;
			}

			if (propChunkSize.TryReadProperty(ref reader, options, PropChunkSize, null))
			{
				continue;
			}

			if (propClient.TryReadProperty(ref reader, options, PropClient, null))
			{
				continue;
			}

			if (propCompress.TryReadProperty(ref reader, options, PropCompress, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propDeleteObjectsMaxSize.TryReadProperty(ref reader, options, PropDeleteObjectsMaxSize, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propGetRegisterRetryDelay.TryReadProperty(ref reader, options, PropGetRegisterRetryDelay, null))
			{
				continue;
			}

			if (propMaxMultipartParts.TryReadProperty(ref reader, options, PropMaxMultipartParts, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMaxMultipartUploadCleanupSize.TryReadProperty(ref reader, options, PropMaxMultipartUploadCleanupSize, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMaxRestoreBytesPerSec.TryReadProperty(ref reader, options, PropMaxRestoreBytesPerSec, null))
			{
				continue;
			}

			if (propMaxSnapshotBytesPerSec.TryReadProperty(ref reader, options, PropMaxSnapshotBytesPerSec, null))
			{
				continue;
			}

			if (propReadonly.TryReadProperty(ref reader, options, PropReadonly, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propServerSideEncryption.TryReadProperty(ref reader, options, PropServerSideEncryption, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propStorageClass.TryReadProperty(ref reader, options, PropStorageClass, null))
			{
				continue;
			}

			if (propThrottledDeleteRetryDelayIncrement.TryReadProperty(ref reader, options, PropThrottledDeleteRetryDelayIncrement, null))
			{
				continue;
			}

			if (propThrottledDeleteRetryMaximumDelay.TryReadProperty(ref reader, options, PropThrottledDeleteRetryMaximumDelay, null))
			{
				continue;
			}

			if (propThrottledDeleteRetryMaximumNumberOfRetries.TryReadProperty(ref reader, options, PropThrottledDeleteRetryMaximumNumberOfRetries, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			BasePath = propBasePath.Value,
			Bucket = propBucket.Value,
			BufferSize = propBufferSize.Value,
			CannedAcl = propCannedAcl.Value,
			ChunkSize = propChunkSize.Value,
			Client = propClient.Value,
			Compress = propCompress.Value,
			DeleteObjectsMaxSize = propDeleteObjectsMaxSize.Value,
			GetRegisterRetryDelay = propGetRegisterRetryDelay.Value,
			MaxMultipartParts = propMaxMultipartParts.Value,
			MaxMultipartUploadCleanupSize = propMaxMultipartUploadCleanupSize.Value,
			MaxRestoreBytesPerSec = propMaxRestoreBytesPerSec.Value,
			MaxSnapshotBytesPerSec = propMaxSnapshotBytesPerSec.Value,
			Readonly = propReadonly.Value,
			ServerSideEncryption = propServerSideEncryption.Value,
			StorageClass = propStorageClass.Value,
			ThrottledDeleteRetryDelayIncrement = propThrottledDeleteRetryDelayIncrement.Value,
			ThrottledDeleteRetryMaximumDelay = propThrottledDeleteRetryMaximumDelay.Value,
			ThrottledDeleteRetryMaximumNumberOfRetries = propThrottledDeleteRetryMaximumNumberOfRetries.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Snapshot.S3RepositorySettings value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropBasePath, value.BasePath, null, null);
		writer.WriteProperty(options, PropBucket, value.Bucket, null, null);
		writer.WriteProperty(options, PropBufferSize, value.BufferSize, null, null);
		writer.WriteProperty(options, PropCannedAcl, value.CannedAcl, null, null);
		writer.WriteProperty(options, PropChunkSize, value.ChunkSize, null, null);
		writer.WriteProperty(options, PropClient, value.Client, null, null);
		writer.WriteProperty(options, PropCompress, value.Compress, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropDeleteObjectsMaxSize, value.DeleteObjectsMaxSize, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropGetRegisterRetryDelay, value.GetRegisterRetryDelay, null, null);
		writer.WriteProperty(options, PropMaxMultipartParts, value.MaxMultipartParts, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMaxMultipartUploadCleanupSize, value.MaxMultipartUploadCleanupSize, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMaxRestoreBytesPerSec, value.MaxRestoreBytesPerSec, null, null);
		writer.WriteProperty(options, PropMaxSnapshotBytesPerSec, value.MaxSnapshotBytesPerSec, null, null);
		writer.WriteProperty(options, PropReadonly, value.Readonly, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropServerSideEncryption, value.ServerSideEncryption, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropStorageClass, value.StorageClass, null, null);
		writer.WriteProperty(options, PropThrottledDeleteRetryDelayIncrement, value.ThrottledDeleteRetryDelayIncrement, null, null);
		writer.WriteProperty(options, PropThrottledDeleteRetryMaximumDelay, value.ThrottledDeleteRetryMaximumDelay, null, null);
		writer.WriteProperty(options, PropThrottledDeleteRetryMaximumNumberOfRetries, value.ThrottledDeleteRetryMaximumNumberOfRetries, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteEndObject();
	}
}