// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.IRepositoryConverter))]
public partial interface IRepository
{
	public string Type { get; }
}

public readonly partial struct RepositoryFactory
{
	public Elastic.Clients.Elasticsearch.Snapshot.IRepository Azure(Elastic.Clients.Elasticsearch.Snapshot.AzureRepository value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.IRepository Azure()
	{
		return Elastic.Clients.Elasticsearch.Snapshot.AzureRepositoryDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Snapshot.IRepository Azure(System.Action<Elastic.Clients.Elasticsearch.Snapshot.AzureRepositoryDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Snapshot.AzureRepositoryDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Snapshot.IRepository SharedFileSystem(Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepository value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.IRepository SharedFileSystem(System.Action<Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositoryDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepositoryDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Snapshot.IRepository Gcs(Elastic.Clients.Elasticsearch.Snapshot.GcsRepository value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.IRepository Gcs(System.Action<Elastic.Clients.Elasticsearch.Snapshot.GcsRepositoryDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Snapshot.GcsRepositoryDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Snapshot.IRepository S3(Elastic.Clients.Elasticsearch.Snapshot.S3Repository value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.IRepository S3(System.Action<Elastic.Clients.Elasticsearch.Snapshot.S3RepositoryDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Snapshot.S3RepositoryDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Snapshot.IRepository SourceOnly(Elastic.Clients.Elasticsearch.Snapshot.SourceOnlyRepository value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.IRepository SourceOnly(System.Action<Elastic.Clients.Elasticsearch.Snapshot.SourceOnlyRepositoryDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Snapshot.SourceOnlyRepositoryDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Snapshot.IRepository ReadOnlyUrl(Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepository value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.IRepository ReadOnlyUrl(System.Action<Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepositoryDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepositoryDescriptor.Build(action);
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Snapshot.IRepository Build(System.Func<Elastic.Clients.Elasticsearch.Snapshot.RepositoryFactory, Elastic.Clients.Elasticsearch.Snapshot.IRepository> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RepositoryFactory();
		return action.Invoke(builder);
	}
}