// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot.Json;

public sealed partial class IRepositoryConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Snapshot.IRepository>
{
	private static readonly System.Text.Json.JsonEncodedText PropDiscriminator = System.Text.Json.JsonEncodedText.Encode("type");

	public override Elastic.Clients.Elasticsearch.Snapshot.IRepository Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		var readerSnapshot = reader;
		string? discriminator = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.TryReadProperty(options, PropDiscriminator, ref discriminator, null))
			{
				break;
			}

			reader.SafeSkip();
		}

		reader = readerSnapshot;
		return discriminator switch
		{
			"azure" => reader.ReadValue<Elastic.Clients.Elasticsearch.Snapshot.AzureRepository>(options, null),
			"fs" => reader.ReadValue<Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepository>(options, null),
			"gcs" => reader.ReadValue<Elastic.Clients.Elasticsearch.Snapshot.GcsRepository>(options, null),
			"s3" => reader.ReadValue<Elastic.Clients.Elasticsearch.Snapshot.S3Repository>(options, null),
			"source" => reader.ReadValue<Elastic.Clients.Elasticsearch.Snapshot.SourceOnlyRepository>(options, null),
			"url" => reader.ReadValue<Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepository>(options, null),
			_ => throw new System.Text.Json.JsonException($"Variant '{discriminator}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Snapshot.IRepository)}'.")
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Snapshot.IRepository value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value.Type)
		{
			case "azure":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Snapshot.AzureRepository)value, null);
				break;
			case "fs":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Snapshot.SharedFileSystemRepository)value, null);
				break;
			case "gcs":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Snapshot.GcsRepository)value, null);
				break;
			case "s3":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Snapshot.S3Repository)value, null);
				break;
			case "source":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Snapshot.SourceOnlyRepository)value, null);
				break;
			case "url":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepository)value, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.Type}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Snapshot.IRepository)}'.");
		}
	}
}