// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.ReadSummaryInfoConverter))]
public sealed partial class ReadSummaryInfo
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ReadSummaryInfo(int count, Elastic.Clients.Elasticsearch.Duration maxWait, System.TimeSpan maxWaitNanos, Elastic.Clients.Elasticsearch.Duration totalElapsed, System.TimeSpan totalElapsedNanos, Elastic.Clients.Elasticsearch.ByteSize totalSize, long totalSizeBytes, Elastic.Clients.Elasticsearch.Duration totalThrottled, System.TimeSpan totalThrottledNanos, Elastic.Clients.Elasticsearch.Duration totalWait, System.TimeSpan totalWaitNanos)
	{
		Count = count;
		MaxWait = maxWait;
		MaxWaitNanos = maxWaitNanos;
		TotalElapsed = totalElapsed;
		TotalElapsedNanos = totalElapsedNanos;
		TotalSize = totalSize;
		TotalSizeBytes = totalSizeBytes;
		TotalThrottled = totalThrottled;
		TotalThrottledNanos = totalThrottledNanos;
		TotalWait = totalWait;
		TotalWaitNanos = totalWaitNanos;
	}
#if NET7_0_OR_GREATER
	public ReadSummaryInfo()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ReadSummaryInfo()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ReadSummaryInfo(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The number of read operations performed in the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Count { get; set; }

	/// <summary>
	/// <para>
	/// The maximum time spent waiting for the first byte of any read request to be received.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Duration MaxWait { get; set; }

	/// <summary>
	/// <para>
	/// The maximum time spent waiting for the first byte of any read request to be received, in nanoseconds.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan MaxWaitNanos { get; set; }

	/// <summary>
	/// <para>
	/// The total elapsed time spent on reading blobs in the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Duration TotalElapsed { get; set; }

	/// <summary>
	/// <para>
	/// The total elapsed time spent on reading blobs in the test, in nanoseconds.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan TotalElapsedNanos { get; set; }

	/// <summary>
	/// <para>
	/// The total size of all the blobs or partial blobs read in the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.ByteSize TotalSize { get; set; }

	/// <summary>
	/// <para>
	/// The total size of all the blobs or partial blobs read in the test, in bytes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long TotalSizeBytes { get; set; }

	/// <summary>
	/// <para>
	/// The total time spent waiting due to the <c>max_restore_bytes_per_sec</c> or <c>indices.recovery.max_bytes_per_sec</c> throttles.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Duration TotalThrottled { get; set; }

	/// <summary>
	/// <para>
	/// The total time spent waiting due to the <c>max_restore_bytes_per_sec</c> or <c>indices.recovery.max_bytes_per_sec</c> throttles, in nanoseconds.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan TotalThrottledNanos { get; set; }

	/// <summary>
	/// <para>
	/// The total time spent waiting for the first byte of each read request to be received.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Duration TotalWait { get; set; }

	/// <summary>
	/// <para>
	/// The total time spent waiting for the first byte of each read request to be received, in nanoseconds.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan TotalWaitNanos { get; set; }
}