// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.ReadOnlyUrlRepositoryConverter))]
public sealed partial class ReadOnlyUrlRepository : Elastic.Clients.Elasticsearch.Snapshot.IRepository
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ReadOnlyUrlRepository(Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepositorySettings settings)
	{
		Settings = settings;
	}
#if NET7_0_OR_GREATER
	public ReadOnlyUrlRepository()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ReadOnlyUrlRepository()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ReadOnlyUrlRepository(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The repository settings.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepositorySettings Settings { get; set; }

	/// <summary>
	/// <para>
	/// The read-only URL repository type.
	/// </para>
	/// </summary>
	public string Type => "url";

	public string? Uuid { get; set; }
}

public readonly partial struct ReadOnlyUrlRepositoryDescriptor
{
	internal Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepository Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ReadOnlyUrlRepositoryDescriptor(Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepository instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ReadOnlyUrlRepositoryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepository(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepositoryDescriptor(Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepository instance) => new Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepositoryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepository(Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepositoryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The repository settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepositoryDescriptor Settings(Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepositorySettings value)
	{
		Instance.Settings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The repository settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepositoryDescriptor Settings(System.Action<Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepositorySettingsDescriptor> action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepositorySettingsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepositoryDescriptor Uuid(string? value)
	{
		Instance.Uuid = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepository Build(System.Action<Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepositoryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepositoryDescriptor(new Elastic.Clients.Elasticsearch.Snapshot.ReadOnlyUrlRepository(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}