// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.ReadBlobDetailsConverter))]
public sealed partial class ReadBlobDetails
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ReadBlobDetails(System.TimeSpan firstByteTimeNanos, bool found, Elastic.Clients.Elasticsearch.Snapshot.SnapshotNodeInfo node)
	{
		FirstByteTimeNanos = firstByteTimeNanos;
		Found = found;
		Node = node;
	}
#if NET7_0_OR_GREATER
	public ReadBlobDetails()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ReadBlobDetails()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ReadBlobDetails(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Indicates whether the read operation may have started before the write operation was complete.
	/// </para>
	/// </summary>
	public bool? BeforeWriteComplete { get; set; }

	/// <summary>
	/// <para>
	/// The length of time spent reading the blob.
	/// If the blob was not found, this detail is omitted.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Elapsed { get; set; }

	/// <summary>
	/// <para>
	/// The length of time spent reading the blob, in nanoseconds.
	/// If the blob was not found, this detail is omitted.
	/// </para>
	/// </summary>
	public System.TimeSpan? ElapsedNanos { get; set; }

	/// <summary>
	/// <para>
	/// The length of time waiting for the first byte of the read operation to be received.
	/// If the blob was not found, this detail is omitted.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? FirstByteTime { get; set; }

	/// <summary>
	/// <para>
	/// The length of time waiting for the first byte of the read operation to be received, in nanoseconds.
	/// If the blob was not found, this detail is omitted.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan FirstByteTimeNanos { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether the blob was found by the read operation.
	/// If the read was started before the write completed or the write was ended before completion, it might be false.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool Found { get; set; }

	/// <summary>
	/// <para>
	/// The node that performed the read operation.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Snapshot.SnapshotNodeInfo Node { get; set; }

	/// <summary>
	/// <para>
	/// The length of time spent waiting due to the <c>max_restore_bytes_per_sec</c> or <c>indices.recovery.max_bytes_per_sec</c> throttles during the read of the blob.
	/// If the blob was not found, this detail is omitted.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Throttled { get; set; }

	/// <summary>
	/// <para>
	/// The length of time spent waiting due to the <c>max_restore_bytes_per_sec</c> or <c>indices.recovery.max_bytes_per_sec</c> throttles during the read of the blob, in nanoseconds.
	/// If the blob was not found, this detail is omitted.
	/// </para>
	/// </summary>
	public System.TimeSpan? ThrottledNanos { get; set; }
}