// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot.Json;

public sealed partial class ReadBlobDetailsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Snapshot.ReadBlobDetails>
{
	private static readonly System.Text.Json.JsonEncodedText PropBeforeWriteComplete = System.Text.Json.JsonEncodedText.Encode("before_write_complete");
	private static readonly System.Text.Json.JsonEncodedText PropElapsed = System.Text.Json.JsonEncodedText.Encode("elapsed");
	private static readonly System.Text.Json.JsonEncodedText PropElapsedNanos = System.Text.Json.JsonEncodedText.Encode("elapsed_nanos");
	private static readonly System.Text.Json.JsonEncodedText PropFirstByteTime = System.Text.Json.JsonEncodedText.Encode("first_byte_time");
	private static readonly System.Text.Json.JsonEncodedText PropFirstByteTimeNanos = System.Text.Json.JsonEncodedText.Encode("first_byte_time_nanos");
	private static readonly System.Text.Json.JsonEncodedText PropFound = System.Text.Json.JsonEncodedText.Encode("found");
	private static readonly System.Text.Json.JsonEncodedText PropNode = System.Text.Json.JsonEncodedText.Encode("node");
	private static readonly System.Text.Json.JsonEncodedText PropThrottled = System.Text.Json.JsonEncodedText.Encode("throttled");
	private static readonly System.Text.Json.JsonEncodedText PropThrottledNanos = System.Text.Json.JsonEncodedText.Encode("throttled_nanos");

	public override Elastic.Clients.Elasticsearch.Snapshot.ReadBlobDetails Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<bool?> propBeforeWriteComplete = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propElapsed = default;
		LocalJsonValue<System.TimeSpan?> propElapsedNanos = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propFirstByteTime = default;
		LocalJsonValue<System.TimeSpan> propFirstByteTimeNanos = default;
		LocalJsonValue<bool> propFound = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Snapshot.SnapshotNodeInfo> propNode = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propThrottled = default;
		LocalJsonValue<System.TimeSpan?> propThrottledNanos = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propBeforeWriteComplete.TryReadProperty(ref reader, options, PropBeforeWriteComplete, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propElapsed.TryReadProperty(ref reader, options, PropElapsed, null))
			{
				continue;
			}

			if (propElapsedNanos.TryReadProperty(ref reader, options, PropElapsedNanos, static System.TimeSpan? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker))))
			{
				continue;
			}

			if (propFirstByteTime.TryReadProperty(ref reader, options, PropFirstByteTime, null))
			{
				continue;
			}

			if (propFirstByteTimeNanos.TryReadProperty(ref reader, options, PropFirstByteTimeNanos, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker))))
			{
				continue;
			}

			if (propFound.TryReadProperty(ref reader, options, PropFound, null))
			{
				continue;
			}

			if (propNode.TryReadProperty(ref reader, options, PropNode, null))
			{
				continue;
			}

			if (propThrottled.TryReadProperty(ref reader, options, PropThrottled, null))
			{
				continue;
			}

			if (propThrottledNanos.TryReadProperty(ref reader, options, PropThrottledNanos, static System.TimeSpan? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker))))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Snapshot.ReadBlobDetails(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			BeforeWriteComplete = propBeforeWriteComplete.Value,
			Elapsed = propElapsed.Value,
			ElapsedNanos = propElapsedNanos.Value,
			FirstByteTime = propFirstByteTime.Value,
			FirstByteTimeNanos = propFirstByteTimeNanos.Value,
			Found = propFound.Value,
			Node = propNode.Value,
			Throttled = propThrottled.Value,
			ThrottledNanos = propThrottledNanos.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Snapshot.ReadBlobDetails value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropBeforeWriteComplete, value.BeforeWriteComplete, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropElapsed, value.Elapsed, null, null);
		writer.WriteProperty(options, PropElapsedNanos, value.ElapsedNanos, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan? v) => w.WriteNullableValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker)));
		writer.WriteProperty(options, PropFirstByteTime, value.FirstByteTime, null, null);
		writer.WriteProperty(options, PropFirstByteTimeNanos, value.FirstByteTimeNanos, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker)));
		writer.WriteProperty(options, PropFound, value.Found, null, null);
		writer.WriteProperty(options, PropNode, value.Node, null, null);
		writer.WriteProperty(options, PropThrottled, value.Throttled, null, null);
		writer.WriteProperty(options, PropThrottledNanos, value.ThrottledNanos, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan? v) => w.WriteNullableValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker)));
		writer.WriteEndObject();
	}
}