// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.GcsRepositorySettingsConverter))]
public sealed partial class GcsRepositorySettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GcsRepositorySettings(string bucket)
	{
		Bucket = bucket;
	}
#if NET7_0_OR_GREATER
	public GcsRepositorySettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public GcsRepositorySettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GcsRepositorySettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The name used by the client when it uses the Google Cloud Storage service.
	/// </para>
	/// </summary>
	[System.Obsolete("Deprecated in '6.3.0'.")]
	public string? ApplicationName { get; set; }

	/// <summary>
	/// <para>
	/// The path to the repository data within the bucket.
	/// It defaults to the root of the bucket.
	/// </para>
	/// <para>
	/// NOTE: Don't set <c>base_path</c> when configuring a snapshot repository for Elastic Cloud Enterprise.
	/// Elastic Cloud Enterprise automatically generates the <c>base_path</c> for each deployment so that multiple deployments can share the same bucket.
	/// </para>
	/// </summary>
	public string? BasePath { get; set; }

	/// <summary>
	/// <para>
	/// The name of the bucket to be used for snapshots.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Bucket { get; set; }

	/// <summary>
	/// <para>
	/// Big files can be broken down into multiple smaller blobs in the blob store during snapshotting.
	/// It is not recommended to change this value from its default unless there is an explicit reason for limiting the size of blobs in the repository.
	/// Setting a value lower than the default can result in an increased number of API calls to the blob store during snapshot create and restore operations compared to using the default value and thus make both operations slower and more costly.
	/// Specify the chunk size as a byte unit, for example: <c>10MB</c>, <c>5KB</c>, 500B.
	/// The default varies by repository type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? ChunkSize { get; set; }

	/// <summary>
	/// <para>
	/// The name of the client to use to connect to Google Cloud Storage.
	/// </para>
	/// </summary>
	public string? Client { get; set; }

	/// <summary>
	/// <para>
	/// When set to <c>true</c>, metadata files are stored in compressed format.
	/// This setting doesn't affect index files that are already compressed by default.
	/// </para>
	/// </summary>
	public bool? Compress { get; set; }

	/// <summary>
	/// <para>
	/// The maximum snapshot restore rate per node.
	/// It defaults to unlimited.
	/// Note that restores are also throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxRestoreBytesPerSec { get; set; }

	/// <summary>
	/// <para>
	/// The maximum snapshot creation rate per node.
	/// It defaults to 40mb per second.
	/// Note that if the recovery settings for managed services are set, then it defaults to unlimited, and the rate is additionally throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxSnapshotBytesPerSec { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the repository is read-only.
	/// The cluster can retrieve and restore snapshots from the repository but not write to the repository or create snapshots in it.
	/// </para>
	/// <para>
	/// Only a cluster with write access can create snapshots in the repository.
	/// All other clusters connected to the repository should have the <c>readonly</c> parameter set to <c>true</c>.
	/// </para>
	/// <para>
	/// If <c>false</c>, the cluster can write to the repository and create snapshots in it.
	/// </para>
	/// <para>
	/// IMPORTANT: If you register the same snapshot repository with multiple clusters, only one cluster should have write access to the repository.
	/// Having multiple clusters write to the repository at the same time risks corrupting the contents of the repository.
	/// </para>
	/// </summary>
	public bool? Readonly { get; set; }
}

public readonly partial struct GcsRepositorySettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GcsRepositorySettingsDescriptor(Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GcsRepositorySettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor(Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettings instance) => new Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettings(Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor descriptor) => descriptor.Instance;

	[System.Obsolete("Deprecated in '6.3.0'.")]
	/// <summary>
	/// <para>
	/// The name used by the client when it uses the Google Cloud Storage service.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor ApplicationName(string? value)
	{
		Instance.ApplicationName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The path to the repository data within the bucket.
	/// It defaults to the root of the bucket.
	/// </para>
	/// <para>
	/// NOTE: Don't set <c>base_path</c> when configuring a snapshot repository for Elastic Cloud Enterprise.
	/// Elastic Cloud Enterprise automatically generates the <c>base_path</c> for each deployment so that multiple deployments can share the same bucket.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor BasePath(string? value)
	{
		Instance.BasePath = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the bucket to be used for snapshots.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor Bucket(string value)
	{
		Instance.Bucket = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Big files can be broken down into multiple smaller blobs in the blob store during snapshotting.
	/// It is not recommended to change this value from its default unless there is an explicit reason for limiting the size of blobs in the repository.
	/// Setting a value lower than the default can result in an increased number of API calls to the blob store during snapshot create and restore operations compared to using the default value and thus make both operations slower and more costly.
	/// Specify the chunk size as a byte unit, for example: <c>10MB</c>, <c>5KB</c>, 500B.
	/// The default varies by repository type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor ChunkSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.ChunkSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Big files can be broken down into multiple smaller blobs in the blob store during snapshotting.
	/// It is not recommended to change this value from its default unless there is an explicit reason for limiting the size of blobs in the repository.
	/// Setting a value lower than the default can result in an increased number of API calls to the blob store during snapshot create and restore operations compared to using the default value and thus make both operations slower and more costly.
	/// Specify the chunk size as a byte unit, for example: <c>10MB</c>, <c>5KB</c>, 500B.
	/// The default varies by repository type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor ChunkSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.ChunkSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the client to use to connect to Google Cloud Storage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor Client(string? value)
	{
		Instance.Client = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// When set to <c>true</c>, metadata files are stored in compressed format.
	/// This setting doesn't affect index files that are already compressed by default.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor Compress(bool? value = true)
	{
		Instance.Compress = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum snapshot restore rate per node.
	/// It defaults to unlimited.
	/// Note that restores are also throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor MaxRestoreBytesPerSec(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxRestoreBytesPerSec = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum snapshot restore rate per node.
	/// It defaults to unlimited.
	/// Note that restores are also throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor MaxRestoreBytesPerSec(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxRestoreBytesPerSec = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum snapshot creation rate per node.
	/// It defaults to 40mb per second.
	/// Note that if the recovery settings for managed services are set, then it defaults to unlimited, and the rate is additionally throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor MaxSnapshotBytesPerSec(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxSnapshotBytesPerSec = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum snapshot creation rate per node.
	/// It defaults to 40mb per second.
	/// Note that if the recovery settings for managed services are set, then it defaults to unlimited, and the rate is additionally throttled through recovery settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor MaxSnapshotBytesPerSec(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxSnapshotBytesPerSec = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the repository is read-only.
	/// The cluster can retrieve and restore snapshots from the repository but not write to the repository or create snapshots in it.
	/// </para>
	/// <para>
	/// Only a cluster with write access can create snapshots in the repository.
	/// All other clusters connected to the repository should have the <c>readonly</c> parameter set to <c>true</c>.
	/// </para>
	/// <para>
	/// If <c>false</c>, the cluster can write to the repository and create snapshots in it.
	/// </para>
	/// <para>
	/// IMPORTANT: If you register the same snapshot repository with multiple clusters, only one cluster should have write access to the repository.
	/// Having multiple clusters write to the repository at the same time risks corrupting the contents of the repository.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor Readonly(bool? value = true)
	{
		Instance.Readonly = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettings Build(System.Action<Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor(new Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}