// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot.Json;

public sealed partial class GcsRepositorySettingsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettings>
{
	private static readonly System.Text.Json.JsonEncodedText PropApplicationName = System.Text.Json.JsonEncodedText.Encode("application_name");
	private static readonly System.Text.Json.JsonEncodedText PropBasePath = System.Text.Json.JsonEncodedText.Encode("base_path");
	private static readonly System.Text.Json.JsonEncodedText PropBucket = System.Text.Json.JsonEncodedText.Encode("bucket");
	private static readonly System.Text.Json.JsonEncodedText PropChunkSize = System.Text.Json.JsonEncodedText.Encode("chunk_size");
	private static readonly System.Text.Json.JsonEncodedText PropClient = System.Text.Json.JsonEncodedText.Encode("client");
	private static readonly System.Text.Json.JsonEncodedText PropCompress = System.Text.Json.JsonEncodedText.Encode("compress");
	private static readonly System.Text.Json.JsonEncodedText PropMaxRestoreBytesPerSec = System.Text.Json.JsonEncodedText.Encode("max_restore_bytes_per_sec");
	private static readonly System.Text.Json.JsonEncodedText PropMaxSnapshotBytesPerSec = System.Text.Json.JsonEncodedText.Encode("max_snapshot_bytes_per_sec");
	private static readonly System.Text.Json.JsonEncodedText PropReadonly = System.Text.Json.JsonEncodedText.Encode("readonly");

	public override Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettings Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propApplicationName = default;
		LocalJsonValue<string?> propBasePath = default;
		LocalJsonValue<string> propBucket = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propChunkSize = default;
		LocalJsonValue<string?> propClient = default;
		LocalJsonValue<bool?> propCompress = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propMaxRestoreBytesPerSec = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propMaxSnapshotBytesPerSec = default;
		LocalJsonValue<bool?> propReadonly = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propApplicationName.TryReadProperty(ref reader, options, PropApplicationName, null))
			{
				continue;
			}

			if (propBasePath.TryReadProperty(ref reader, options, PropBasePath, null))
			{
				continue;
			}

			if (propBucket.TryReadProperty(ref reader, options, PropBucket, null))
			{
				continue;
			}

			if (propChunkSize.TryReadProperty(ref reader, options, PropChunkSize, null))
			{
				continue;
			}

			if (propClient.TryReadProperty(ref reader, options, PropClient, null))
			{
				continue;
			}

			if (propCompress.TryReadProperty(ref reader, options, PropCompress, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propMaxRestoreBytesPerSec.TryReadProperty(ref reader, options, PropMaxRestoreBytesPerSec, null))
			{
				continue;
			}

			if (propMaxSnapshotBytesPerSec.TryReadProperty(ref reader, options, PropMaxSnapshotBytesPerSec, null))
			{
				continue;
			}

			if (propReadonly.TryReadProperty(ref reader, options, PropReadonly, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
#pragma warning disable CS0618
			ApplicationName = propApplicationName.Value
#pragma warning restore CS0618
,
			BasePath = propBasePath.Value,
			Bucket = propBucket.Value,
			ChunkSize = propChunkSize.Value,
			Client = propClient.Value,
			Compress = propCompress.Value,
			MaxRestoreBytesPerSec = propMaxRestoreBytesPerSec.Value,
			MaxSnapshotBytesPerSec = propMaxSnapshotBytesPerSec.Value,
			Readonly = propReadonly.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettings value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
#pragma warning disable CS0618
		writer.WriteProperty(options, PropApplicationName, value.ApplicationName, null, null)
#pragma warning restore CS0618
		;
		writer.WriteProperty(options, PropBasePath, value.BasePath, null, null);
		writer.WriteProperty(options, PropBucket, value.Bucket, null, null);
		writer.WriteProperty(options, PropChunkSize, value.ChunkSize, null, null);
		writer.WriteProperty(options, PropClient, value.Client, null, null);
		writer.WriteProperty(options, PropCompress, value.Compress, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropMaxRestoreBytesPerSec, value.MaxRestoreBytesPerSec, null, null);
		writer.WriteProperty(options, PropMaxSnapshotBytesPerSec, value.MaxSnapshotBytesPerSec, null, null);
		writer.WriteProperty(options, PropReadonly, value.Readonly, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteEndObject();
	}
}